/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.cdkey;

import com.javaop.BNetLogin.cdkey.Decode;
import com.javaop.BNetLogin.password.BrokenSHA1;
import com.javaop.util.Buffer;

class Num13Decode
extends Decode {
    protected String cdkey;

    public Num13Decode(String string) throws IllegalArgumentException {
        this.cdkey = string;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("CD-Key is missing!");
        }
        if (string.length() != 13) {
            throw new IllegalArgumentException("CDKey is not 13 characters!");
        }
        if (!this.verify()) {
            throw new IllegalArgumentException("CDKey is invalid: did not pass local checks");
        }
        this.shuffle();
        this.getFinalValue();
    }

    @Override
    public int[] getKeyHash(int n, int n2) {
        Buffer buffer = new Buffer();
        buffer.addDWord(n);
        buffer.addDWord(n2);
        buffer.addDWord(this.getProduct());
        buffer.addDWord(this.getVal1());
        buffer.addDWord(0);
        buffer.addDWord(this.getVal2());
        return BrokenSHA1.calcHashBuffer(buffer.getBytes());
    }

    protected boolean verify() {
        int n = 3;
        this.cdkey = this.cdkey.toLowerCase();
        for (int i = 0; i < this.cdkey.length() - 1; ++i) {
            n += this.cdkey.charAt(i) - 48 ^ n * 2;
        }
        return n % 10 == this.cdkey.charAt(12) - 48;
    }

    protected static String swap(String string, int n, int n2) {
        byte[] byArray = string.getBytes();
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
        return new String(byArray);
    }

    protected void shuffle() {
        int n = 11;
        for (int i = 194; i >= 7; i -= 17) {
            this.cdkey = Num13Decode.swap(this.cdkey, n--, i % 12);
        }
    }

    protected void getFinalValue() {
        int n = 330078017;
        byte[] byArray = this.cdkey.getBytes();
        for (int i = this.cdkey.length() - 2; i >= 0; --i) {
            if (byArray[i] <= 55) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] ^ (byte)(n & 7));
                n >>>= 3;
                continue;
            }
            if (byArray[i] >= 65) continue;
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] ^ (byte)(i & 1));
        }
        this.cdkey = new String(byArray);
    }

    @Override
    public int getProduct() {
        return Integer.parseInt(this.cdkey.substring(0, 2));
    }

    @Override
    public int getVal2() {
        return Integer.parseInt(this.cdkey.substring(9, 12));
    }

    @Override
    public int getVal1() {
        return Integer.parseInt(this.cdkey.substring(2, 9));
    }

    public String toString() {
        return "13-character numeric decoder";
    }
}

