/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.cdkey;

import com.javaop.BNetLogin.cdkey.Alpha16Decode;
import com.javaop.BNetLogin.cdkey.Alpha26Decode;
import com.javaop.BNetLogin.cdkey.Num13Decode;

public class Decode {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.out.println("Usage: java cdkey/Decode [cdkey]");
                System.exit(-1);
            }
            Decode decode = Decode.getDecoder(stringArray[0]);
            switch (stringArray[0].length()) {
                case 26: {
                    System.out.println("Key:     " + stringArray[0]);
                    System.out.println("Decoder: " + decode.toString());
                    System.out.println("Value 1: 0x" + Integer.toHexString(decode.getVal1()));
                    byte[] byArray = ((Alpha26Decode)decode).getWar3Val2();
                    System.out.print("Value 2: 0x");
                    for (int i = 0; i < byArray.length; ++i) {
                        System.out.print(Integer.toHexString(byArray[i]) + " ");
                    }
                    System.out.println("\nProduct: 0x" + Integer.toHexString(decode.getProduct()));
                    break;
                }
                default: {
                    System.out.println("Key:     " + stringArray[0]);
                    System.out.println("Decoder: " + decode.toString());
                    System.out.println("Value 1: 0x" + Integer.toHexString(decode.getVal1()));
                    System.out.println("Value 2: 0x" + Integer.toHexString(decode.getVal2()));
                    System.out.println("Product: 0x" + Integer.toHexString(decode.getProduct()));
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static Decode getDecoder(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("CD-Key is missing!");
        }
        switch (string.length()) {
            case 13: {
                return new Num13Decode(string);
            }
            case 16: {
                return new Alpha16Decode(string);
            }
            case 26: {
                return new Alpha26Decode(string);
            }
        }
        throw new IllegalArgumentException("CD-Key type cannot be determined: " + string.toString());
    }

    public int[] getKeyHash(int n, int n2) {
        return new int[]{0, 0, 0, 0, 0};
    }

    public int getProduct() {
        return 0;
    }

    public int getVal1() {
        return 0;
    }

    public int getVal2() {
        return 0;
    }
}

