/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.cdkey;

import com.javaop.BNetLogin.cdkey.Decode;
import com.javaop.BNetLogin.password.ByteFromIntArray;
import com.javaop.BNetLogin.password.IntFromByteArray;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class Alpha26Decode
extends Decode {
    public static final byte[] KeyTable = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 1, -1, 2, 3, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, 12, -1, 13, 14, -1, 15, 16, -1, 17, -1, 18, -1, 19, -1, 20, 21, 22, 23, 24, -1, -1, -1, -1, -1, -1, -1, 6, 7, 8, 9, 10, 11, 12, -1, 13, 14, -1, 15, 16, -1, 17, -1, 18, -1, 19, -1, 20, 21, 22, 23, 24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final byte[] TranslateTable = new byte[]{9, 4, 7, 15, 13, 10, 3, 11, 1, 2, 12, 8, 6, 14, 5, 0, 9, 11, 5, 4, 8, 15, 1, 14, 7, 0, 3, 2, 10, 6, 13, 12, 12, 14, 1, 4, 9, 15, 10, 11, 13, 6, 0, 8, 7, 2, 5, 3, 11, 2, 5, 14, 13, 3, 9, 0, 1, 15, 7, 12, 10, 6, 4, 8, 6, 2, 4, 5, 11, 8, 12, 14, 13, 15, 7, 1, 10, 0, 3, 9, 5, 4, 14, 12, 7, 6, 13, 10, 15, 2, 9, 1, 0, 11, 8, 3, 12, 7, 8, 15, 11, 0, 5, 9, 13, 10, 6, 14, 2, 4, 3, 1, 3, 10, 14, 8, 1, 11, 5, 4, 2, 15, 13, 12, 6, 7, 9, 0, 12, 13, 1, 15, 8, 14, 5, 11, 3, 10, 9, 0, 7, 2, 4, 6, 13, 10, 7, 14, 1, 6, 11, 8, 15, 12, 5, 2, 3, 0, 4, 9, 3, 14, 7, 5, 11, 15, 8, 12, 1, 10, 4, 13, 0, 6, 9, 2, 11, 6, 9, 4, 1, 8, 10, 13, 7, 14, 0, 12, 15, 2, 3, 5, 12, 7, 8, 13, 3, 11, 0, 14, 6, 15, 9, 4, 10, 1, 5, 2, 12, 6, 13, 9, 11, 0, 1, 2, 15, 7, 3, 4, 10, 14, 8, 5, 3, 6, 1, 5, 11, 12, 8, 0, 15, 14, 9, 4, 7, 10, 13, 2, 10, 7, 11, 15, 2, 8, 0, 13, 14, 12, 1, 6, 9, 3, 5, 4, 10, 11, 13, 4, 3, 8, 5, 9, 1, 0, 15, 12, 7, 14, 2, 6, 11, 4, 13, 15, 1, 6, 3, 14, 7, 10, 12, 8, 9, 2, 5, 0, 9, 6, 7, 0, 1, 10, 13, 2, 3, 14, 15, 12, 5, 11, 4, 8, 13, 14, 5, 6, 1, 9, 8, 12, 2, 15, 3, 7, 11, 4, 0, 10, 9, 15, 4, 0, 1, 6, 10, 14, 2, 3, 7, 13, 5, 11, 8, 12, 3, 14, 1, 10, 2, 12, 8, 4, 11, 7, 13, 0, 15, 6, 9, 5, 7, 2, 12, 6, 10, 8, 11, 0, 15, 4, 3, 14, 9, 1, 13, 5, 12, 4, 5, 9, 10, 2, 8, 13, 3, 15, 1, 14, 6, 7, 11, 0, 10, 8, 14, 13, 9, 15, 3, 0, 4, 6, 1, 12, 7, 11, 2, 5, 3, 12, 4, 10, 2, 15, 13, 14, 7, 0, 5, 8, 1, 6, 11, 9, 10, 12, 1, 0, 9, 14, 13, 11, 3, 7, 15, 8, 5, 2, 4, 6, 14, 10, 1, 8, 7, 6, 5, 12, 2, 15, 0, 13, 3, 11, 4, 9, 3, 8, 14, 0, 7, 9, 15, 12, 1, 6, 13, 2, 5, 10, 11, 4, 3, 10, 12, 4, 13, 11, 9, 14, 15, 6, 1, 7, 2, 0, 5, 8};
    private int KEYLEN = 26;
    private int BUFLEN = 52;
    private int val1;
    private byte[] val2;
    private int product;

    public Alpha26Decode(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("CD-Key is missing!");
        }
        if (string.length() != this.KEYLEN) {
            throw new IllegalArgumentException("CDKey is not 26 characters!");
        }
        byte[] byArray = new byte[this.BUFLEN];
        int[] nArray = new int[4];
        this.tableLookup(string.toUpperCase(), byArray);
        for (int i = this.BUFLEN; i > 0; --i) {
            this.Mult(4, 5, nArray, nArray, byArray[i - 1]);
        }
        this.decodeKeyTablePass1(nArray);
        this.decodeKeyTablePass2(nArray);
        this.product = nArray[0] >> 10;
        this.val1 = (nArray[0] & 0x3FF) << 16 | nArray[1] >>> 16;
        this.val2 = new byte[10];
        this.val2[0] = (byte)((nArray[1] & 0xFF) >> 0);
        this.val2[1] = (byte)((nArray[1] & 0xFF00) >> 8);
        IntFromByteArray.LITTLEENDIAN.insertInteger(this.val2, 2, nArray[2]);
        IntFromByteArray.LITTLEENDIAN.insertInteger(this.val2, 6, nArray[3]);
    }

    private void tableLookup(String string, byte[] byArray) {
        int n = 33;
        for (int i = 0; i < this.KEYLEN; ++i) {
            int n2 = (n + 1973) % this.BUFLEN;
            n = (n2 + 1973) % this.BUFLEN;
            byte by = KeyTable[string.charAt(i)];
            byArray[n2] = (byte)(by / 5);
            byArray[n] = (byte)(by % 5);
        }
    }

    private void Mult(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        int n4 = n - 1;
        int n5 = n - 1;
        while (n-- > 0) {
            long l = nArray[n4--];
            long l2 = n2;
            long l3 = (l &= 0xFFFFFFFFL) * (l2 &= 0xFFFFFFFFL);
            nArray2[n5--] = n3 + (int)l3;
            n3 = (int)(l3 >> 32);
        }
    }

    private void decodeKeyTablePass1(int[] nArray) {
        int n = 29;
        for (int i = 464; i >= 0; i -= 16) {
            int n2;
            int n3;
            int n4;
            int n5 = (n & 7) << 2;
            int n6 = n >>> 3;
            int n7 = (nArray[3 - n6] & 15 << n5) >>> n5;
            if (i < 464) {
                for (n4 = 29; n4 > n; --n4) {
                    n3 = (n4 & 7) << 2;
                    n2 = (nArray[3 - (n4 >>> 3)] & 15 << n3) >>> n3;
                    n7 = TranslateTable[n2 ^ TranslateTable[n7 + i] + i];
                }
            }
            for (n4 = --n; n4 >= 0; --n4) {
                n3 = (n4 & 7) << 2;
                n2 = (nArray[3 - (n4 >>> 3)] & 15 << n3) >>> n3;
                n7 = TranslateTable[n2 ^ TranslateTable[n7 + i] + i];
            }
            n4 = 3 - n6;
            int n8 = (TranslateTable[n7 + i] & 0xF) << n5;
            nArray[n4] = n8 | ~(15 << n5) & nArray[n4];
        }
    }

    void decodeKeyTablePass2(int[] nArray) {
        byte[] byArray = ByteFromIntArray.LITTLEENDIAN.getByteArray(nArray);
        int n = 0;
        for (int i = 0; i < 120; ++i) {
            int n2 = i & 0x1F;
            int n3 = n & 0x1F;
            int n4 = 3 - (i >>> 5);
            int n5 = 12 - (n >>> 5 << 2);
            int n6 = IntFromByteArray.LITTLEENDIAN.getInteger(byArray, n5);
            n6 = (n6 & 1 << n3) >>> n3;
            nArray[n4] = (n6 & 1) << n2 | ~(1 << n2) & nArray[n4];
            if ((n += 11) < 120) continue;
            n -= 120;
        }
    }

    @Override
    public int[] getKeyHash(int n, int n2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = new byte[26];
            IntFromByteArray.LITTLEENDIAN.insertInteger(byArray, 0, n);
            IntFromByteArray.LITTLEENDIAN.insertInteger(byArray, 4, n2);
            IntFromByteArray.LITTLEENDIAN.insertInteger(byArray, 8, this.getProduct());
            IntFromByteArray.LITTLEENDIAN.insertInteger(byArray, 12, this.getVal1());
            for (int i = 16; i < 26; ++i) {
                byArray[i] = this.getWar3Val2()[i - 16];
            }
            messageDigest.update(byArray);
            return IntFromByteArray.LITTLEENDIAN.getIntArray(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Could not find SHA1 library " + noSuchAlgorithmException);
            System.exit(1);
            return null;
        }
    }

    @Override
    public int getVal1() {
        return this.val1;
    }

    @Override
    public int getVal2() {
        throw new UnsupportedOperationException("Can't use Alpha26Decode's getVal2() as an int");
    }

    public byte[] getWar3Val2() {
        return this.val2;
    }

    @Override
    public int getProduct() {
        return this.product;
    }

    public String toString() {
        return "26-character alphanumeric decoder";
    }
}

