/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.cdkey;

import com.javaop.BNetLogin.cdkey.Decode;
import com.javaop.BNetLogin.password.BrokenSHA1;
import com.javaop.util.Buffer;

class Alpha16Decode
extends Decode {
    private String cdkey;
    int[] alpha16Map = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 255, 1, 255, 2, 3, 4, 5, 255, 255, 255, 255, 255, 255, 255, 255, 6, 7, 8, 9, 10, 11, 12, 255, 13, 14, 255, 15, 16, 255, 17, 255, 18, 255, 19, 255, 20, 21, 22, 255, 23, 255, 255, 255, 255, 255, 255, 255, 6, 7, 8, 9, 10, 11, 12, 255, 13, 14, 255, 15, 16, 255, 17, 255, 18, 255, 19, 255, 20, 21, 22, 255, 23, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    private int checksum = 0;

    protected Alpha16Decode(String string) throws IllegalArgumentException {
        this.cdkey = string;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("CD-Key is missing!");
        }
        if (string.length() != 16) {
            throw new IllegalArgumentException("CDKey is not 16 characters!");
        }
        this.hash();
    }

    @Override
    public int[] getKeyHash(int n, int n2) {
        Buffer buffer = new Buffer();
        buffer.addDWord(n);
        buffer.addDWord(n2);
        buffer.addDWord(this.getProduct());
        buffer.addDWord(this.getVal1());
        buffer.addDWord(0);
        buffer.addDWord(this.getVal2());
        return BrokenSHA1.calcHashBuffer(buffer.getBytes());
    }

    private void hash() throws IllegalArgumentException {
        byte by;
        int n;
        byte by2;
        int n2;
        int n3;
        this.checksum = 0;
        char[] cArray = this.cdkey.toCharArray();
        for (n3 = 0; n3 < this.cdkey.length(); n3 += 2) {
            int n4 = 1;
            byte by3 = (byte)this.alpha16Map[this.cdkey.charAt(n3)];
            n2 = by3 * 3;
            by2 = (byte)this.alpha16Map[this.cdkey.charAt(n3 + 1)];
            n2 = by2 + n2 * 8;
            if (n2 >= 256) {
                n2 -= 256;
                this.checksum |= (int)Math.pow(2.0, n3 / 2);
            }
            n = n2;
            cArray[n3] = this.getHexVal(n >>= 4);
            cArray[n3 + 1] = this.getHexVal(n2);
            n4 <<= 1;
        }
        int n5 = 3;
        for (n3 = 0; n3 < 16; ++n3) {
            by = (byte)cArray[n3];
            n2 = this.getNumVal((char)by);
            n = n5 * 2;
            n5 += (n2 ^= n);
        }
        if ((n5 &= 0xFF) != this.checksum) {
            throw new IllegalArgumentException("CD-Key is invalid.");
        }
        for (n3 = 15; n3 >= 0; --n3) {
            by = (byte)cArray[n3];
            n2 = n3 > 8 ? n3 - 9 : 15 - (8 - n3);
            by2 = (byte)cArray[n2 &= 0xF];
            cArray[n3] = (char)by2;
            cArray[n2] = (char)by;
        }
        int n6 = 330078017;
        for (n3 = 15; n3 >= 0; --n3) {
            by = (byte)Character.toUpperCase(cArray[n3]);
            cArray[n3] = (char)by;
            if (by <= 55) {
                n5 = n6;
                by2 = (byte)(n5 & 0xFF);
                by2 = (byte)(by2 & 7);
                by2 = (byte)(by2 ^ by);
                cArray[n3] = (char)by2;
                n6 = n5 >>= 3;
                continue;
            }
            if (by >= 65) continue;
            by2 = (byte)n3;
            by2 = (byte)(by2 & 1);
            by2 = (byte)(by2 ^ by);
            cArray[n3] = (char)by2;
        }
        this.cdkey = new String(cArray);
    }

    private char getHexVal(int n) {
        if ((n &= 0xF) < 10) {
            return (char)(n + 48);
        }
        return (char)(n + 55);
    }

    private int getNumVal(char c) {
        if (Character.isDigit(c = Character.toUpperCase(c))) {
            return c - 48;
        }
        return c - 55;
    }

    @Override
    public int getProduct() {
        return Integer.parseInt(this.cdkey.substring(0, 2), 16);
    }

    @Override
    public int getVal1() {
        return (int)Long.parseLong(this.cdkey.substring(2, 8), 16);
    }

    @Override
    public int getVal2() {
        return (int)Long.parseLong(this.cdkey.substring(8, 16), 16);
    }

    public String toString() {
        return "16-character alphanumeric decoder";
    }
}

