/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin;

import com.javaop.BNetLogin.Login;
import com.javaop.BNetLogin.cdkey.Decode;
import com.javaop.BNetLogin.packets.SidAuthCheck;
import com.javaop.BNetLogin.packets.SidAuthInfo;
import com.javaop.BNetLogin.packets.SidCreateAccount2;
import com.javaop.BNetLogin.packets.SidLogonResponse2;
import com.javaop.BNetLogin.packets.SrpLogin;
import com.javaop.BNetLogin.versioning.Game;
import com.javaop.BNetLogin.versioning.GameData;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.AccountDneException;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.LoginException;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.ConnectionCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.gui.JTextFieldNumeric;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;

public class PluginMain
extends GenericPluginInterface
implements ConnectionCallback,
PacketCallback,
CommandCallback {
    private Login login;
    private PublicExposedFunctions pubFuncs;
    private SrpLogin srpLogin;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.pubFuncs = publicExposedFunctions;
        this.srpLogin = new SrpLogin();
        pluginCallbackRegister.registerConnectionPlugin((ConnectionCallback)this, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 80, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 81, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 58, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 49, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 61, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 94, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 83, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 84, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 82, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 85, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 86, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 10, null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "game", 0, false, "AGLN", "", "Shows the game that the bot is connected as", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "home", 0, false, "J", "", "Tells the bot to go to its home channel", null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public boolean connecting(String string, int n, Object object) {
        try {
            GameData gameData = new GameData();
            boolean bl = gameData.hasTwoKeys(this.pubFuncs.getLocalSetting(this.getName(), "game"));
            Decode.getDecoder(this.pubFuncs.getLocalSetting(this.getName(), "cdkey"));
            if (bl) {
                Decode.getDecoder(this.pubFuncs.getLocalSetting(this.getName(), "cdkey2"));
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.pubFuncs.systemMessage(6, "[BNET] Caught exception while validating CD-Keys: " + illegalArgumentException);
            return false;
        }
    }

    public void connected(String string, int n, Object object) throws PluginException, IOException {
        this.login = new Login(this.getName(), this.srpLogin);
        this.pubFuncs.systemMessage(2, "[BNET] Switching to BnChat protocol and calculating authorization info..");
        this.pubFuncs.sendPacket(this.login.getProtocolByte());
        BnetPacket bnetPacket = SidAuthInfo.getOutgoing(this.pubFuncs);
        this.pubFuncs.systemMessage(2, "[BNET] Calculated. Sending authorization info..");
        this.pubFuncs.sendPacket((Buffer)bnetPacket);
    }

    public boolean disconnecting(Object object) {
        return true;
    }

    public void disconnected(Object object) {
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) {
        switch (bnetPacket.getCode()) {
            case 10: {
                this.pubFuncs.putLocalVariable((Object)"username", (Object)bnetPacket.removeNTString());
                this.pubFuncs.putLocalVariable((Object)"statstring", (Object)bnetPacket.removeNTString());
                this.pubFuncs.unlock();
            }
        }
        return bnetPacket;
    }

    public String getName() {
        return "Battle.net Login Plugin";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago, wjlafrance";
    }

    public String getAuthorWebsite() {
        return "javaop.googlecode.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com, wjlafrance@gmail.com";
    }

    public String getLongDescription() {
        return "This is my version of the Battle.net login.  It starts with sending SID_AUTHINFO when the connection is made, and ends with SID_ENTERCHAT and SID_JOINCHANNEL.  It supports any keyed product, from Starcraft to War3 Expansion. For the code itself, the CD-Key decoding for the legacy products was reversed and written by iago. The CD-Key decoding for Warcraft 3 is based on work done by Maddox and Telos, ported to Java by iago. The CheckRevision and SHA1 code used for the legacy products is based on Yobgul's code, again ported to Java by iago. Finally, the SRP (WarCraft 3 login) code was reversed and written by Maddox, iago, and TheMinistered and ported to Java by iago.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("auto-change password", "false");
        properties.setProperty("auto-change how often", "3");
        properties.setProperty("auto-change password display", "false");
        properties.setProperty("username", "<USERNAME GOES HERE>");
        properties.setProperty("password", "<PASSWORD GOES HERE>");
        properties.setProperty("password change", "");
        properties.setProperty("cdkey", "<CDKEY GOES HERE>");
        properties.setProperty("cdkey2", "");
        properties.setProperty("home channel", "clan bot");
        properties.setProperty("game", "SEXP");
        properties.setProperty("Verify server", "true");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("auto-change password", "If this is set, your password will occasionally be changed to a random string of 10 characters.  This will happen invisibly, but if you use other bots I don't recommend this.  I highly recommend registering your email address if you use this, just in case your config file gets lost.");
        properties.setProperty("auto-change how often", "After how many logs to change the password");
        properties.setProperty("auto-change password display", "If this is enabled, the password is displayed when it is changed.");
        properties.setProperty("username", "The username to log onto Battle.net with.");
        properties.setProperty("password", "The password to log onto Battle.net with.");
        properties.setProperty("password change", "If this is filled in, on the next login your password will be changed to it and the value will be moved to \"password\".  Leave blank for no change. If you were thinking, \"How do I set a blank password?\"away from me.");
        properties.setProperty("cdkey", "The CDKey to log in with.");
        properties.setProperty("cdkey2", "This is the cdkey for Lord of Destruction or The Frozen Throne.");
        properties.setProperty("home channel", "The default channel to join when the bot logs onto Battle.net.");
        properties.setProperty("game", "The game client to log on as.");
        properties.setProperty("Verify server", "Turning this off will still attempt to verify the server, but will force connection even if it's not verified.");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("password") || string.equalsIgnoreCase("password change")) {
            return new JPasswordField(string2);
        }
        if (string.equalsIgnoreCase("Verify server") || string.equalsIgnoreCase("auto-change password") || string.equalsIgnoreCase("auto-change password display")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("game")) {
            JComboBox<String> jComboBox = new JComboBox<String>(Game.getGames());
            jComboBox.setEditable(true);
            jComboBox.setSelectedItem(string2);
            return jComboBox;
        }
        if (string.equalsIgnoreCase("auto-change how often")) {
            return new JTextFieldNumeric(string2);
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("BNLS Server", "bnls.mattkv.net");
        properties.setProperty("Enable BNLS", "true");
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("BNLS Server", "The server that is used for versioning information. It does *NOT* process your cdkey or password, those are done locally.");
        properties.setProperty("Enable BNLS", "Allow the bot to use BNLS? Remember, BNLS will never handle your CD-Key or password.");
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        if (string.equalsIgnoreCase("Enable BNLS")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws IOException, LoginException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("game")) {
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        this.pubFuncs.sendTextUserPriority(string, new Game(stringArray[i]).toString(), n, -50);
                        continue;
                    }
                    catch (Exception exception) {
                        this.pubFuncs.sendTextUserPriority(string, "Game \"" + stringArray[i] + "\" could not be found.", n, -50);
                    }
                }
            } else {
                this.pubFuncs.sendTextUserPriority(string, new Game(this.pubFuncs.getLocalSettingDefault(this.getName(), "game", "STAR")).toString(), n, -50);
            }
        } else if (string2.equalsIgnoreCase("home")) {
            this.pubFuncs.sendPacket((Buffer)this.login.getJoinHomeChannel(this.pubFuncs));
        }
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws PluginException, IOException {
        block1 : switch (bnetPacket.getCode()) {
            case 49: {
                this.pubFuncs.sendPacket((Buffer)this.login.checkPasswordChange(this.pubFuncs, bnetPacket));
                this.pubFuncs.systemMessage(2, "[BNET] Password successfully changed, logging in..");
                break;
            }
            case 58: {
                try {
                    SidLogonResponse2.checkIncoming(this.pubFuncs, bnetPacket);
                    this.pubFuncs.systemMessage(2, "[BNET] Logon successful! Entering chat..");
                    this.pubFuncs.sendPacket((Buffer)this.login.getEnterChat(this.pubFuncs));
                    this.pubFuncs.sendPacket((Buffer)this.login.getJoinHomeChannel(this.pubFuncs));
                }
                catch (AccountDneException accountDneException) {
                    this.pubFuncs.systemMessage(4, "[BNET] Account doesn't exist, attempting to create..");
                    this.pubFuncs.sendPacket((Buffer)SidCreateAccount2.getOutgoing(this.pubFuncs));
                }
                break;
            }
            case 61: {
                this.pubFuncs.sendPacket((Buffer)this.login.checkCreateAccount(this.pubFuncs, bnetPacket));
                this.pubFuncs.systemMessage(2, "[BNET] Account successfully created, trying to log in..");
                break;
            }
            case 80: {
                this.pubFuncs.systemMessage(2, "[BNET] Received response, calculating..");
                BnetPacket bnetPacket2 = SidAuthCheck.getOutgoing(this.pubFuncs, bnetPacket);
                this.pubFuncs.systemMessage(2, "[BNET] Calculated. Sending CD-Key and version check..");
                this.pubFuncs.sendPacket((Buffer)bnetPacket2);
                break;
            }
            case 81: {
                SidAuthCheck.checkIncoming(this.pubFuncs, bnetPacket);
                this.pubFuncs.systemMessage(2, "[BNET] CD-Key and version check successful. Attempting to log in..");
                switch ((Integer)this.pubFuncs.getLocalVariable((Object)"loginType")) {
                    case 0: {
                        this.pubFuncs.sendPacket((Buffer)SidLogonResponse2.getOutgoing(this.pubFuncs));
                        break block1;
                    }
                    case 1: 
                    case 2: {
                        this.pubFuncs.sendPacket((Buffer)this.srpLogin.getSidAuthAccountLogon(this.pubFuncs));
                        break block1;
                    }
                }
                throw new LoginException("[BNET] Unable to login in with login type " + (Integer)this.pubFuncs.getLocalVariable((Object)"loginType"));
            }
            case 82: {
                this.srpLogin.checkSidAuthCreateAccount(this.pubFuncs, bnetPacket);
                this.pubFuncs.systemMessage(2, "[BNET] Account successfully created, trying to log in..");
                this.pubFuncs.sendPacket((Buffer)this.srpLogin.getSidAuthAccountLogon(this.pubFuncs));
                break;
            }
            case 83: {
                this.pubFuncs.systemMessage(2, "[BNET] Login proof requested..");
                this.pubFuncs.sendPacket((Buffer)this.srpLogin.getSidAuthAccountLogonProof(this.pubFuncs, bnetPacket));
                break;
            }
            case 84: {
                this.pubFuncs.systemMessage(2, "[BNET] Checking NLS proof..");
                this.srpLogin.checkSidAuthAccountLogonProof(this.pubFuncs, bnetPacket);
                this.pubFuncs.systemMessage(2, "[BNET] NLS logon successful!");
                this.pubFuncs.sendPacket((Buffer)this.login.getEnterChat(this.pubFuncs));
                this.pubFuncs.sendPacket((Buffer)this.login.getJoinHomeChannel(this.pubFuncs));
                break;
            }
            case 85: {
                this.pubFuncs.systemMessage(2, "[BNET] Password change response received, replying with proof..");
                this.pubFuncs.sendPacket((Buffer)this.srpLogin.getSidAuthAccountChangeProof(this.pubFuncs, bnetPacket));
                break;
            }
            case 86: {
                this.pubFuncs.systemMessage(2, "[BNET] Account change proof received.");
                this.srpLogin.checkSidAuthAccountLogonProof(this.pubFuncs, bnetPacket);
                break;
            }
            case 94: {
                this.pubFuncs.systemMessage(5, "[BNET] Ignoring Warden challenge. You'll most likely be disconnected in two minutes.");
            }
        }
    }
}

