/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin;

import com.javaop.BNetLogin.packets.SidLogonResponse2;
import com.javaop.BNetLogin.packets.SrpLogin;
import com.javaop.BNetLogin.password.BrokenSHA1;
import com.javaop.BNetLogin.password.DoubleHash;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.exceptions.LoginException;
import com.javaop.exceptions.PluginException;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;

public class Login {
    private String prefSection;
    private SrpLogin srpLogin;

    public Login(String string, SrpLogin srpLogin) {
        this.prefSection = string;
        this.srpLogin = srpLogin;
    }

    public Buffer getProtocolByte() {
        return new Buffer(new byte[]{1});
    }

    public BnetPacket checkCreateAccount(PublicExposedFunctions publicExposedFunctions, BnetPacket bnetPacket) throws LoginException, PluginException {
        int n = bnetPacket.removeDWord();
        switch (n) {
            case 0: {
                switch ((Integer)publicExposedFunctions.getLocalVariable((Object)"loginType")) {
                    case 0: {
                        return SidLogonResponse2.getOutgoing(publicExposedFunctions);
                    }
                    case 1: 
                    case 2: {
                        return this.srpLogin.getSidAuthAccountLogon(publicExposedFunctions);
                    }
                }
            }
            case 2: {
                throw new LoginException("[BNET] Name contained invalid characters");
            }
            case 3: {
                throw new LoginException("[BNET] Name contained a banned word");
            }
            case 4: {
                throw new LoginException("[BNET] Account already exists");
            }
            case 6: {
                throw new LoginException("[BNET] Name did not contain enough alphanumeric characters");
            }
        }
        throw new LoginException("[BNET] Unknown error creating account: " + n);
    }

    public BnetPacket getChangePassword(PublicExposedFunctions publicExposedFunctions) throws PluginException {
        String string = publicExposedFunctions.getLocalSetting(this.prefSection, "username");
        String string2 = publicExposedFunctions.getLocalSetting(this.prefSection, "password").toLowerCase();
        int n = (Integer)publicExposedFunctions.getLocalVariable((Object)"loginType");
        int n2 = (Integer)publicExposedFunctions.getLocalVariable((Object)"clientToken");
        int n3 = (Integer)publicExposedFunctions.getLocalVariable((Object)"serverToken");
        if (n == 0) {
            BnetPacket bnetPacket = new BnetPacket(49);
            bnetPacket.add(n2);
            bnetPacket.add(n3);
            int[] nArray = DoubleHash.doubleHash(string2, n2, n3);
            for (int i = 0; i < 5; ++i) {
                bnetPacket.add(nArray[i]);
            }
            int[] nArray2 = BrokenSHA1.calcHashBuffer(publicExposedFunctions.getLocalSetting(this.prefSection, "password change").toLowerCase().getBytes());
            for (int i = 0; i < 5; ++i) {
                bnetPacket.add(nArray2[i]);
            }
            bnetPacket.addNTString(string);
            return bnetPacket;
        }
        if (n == 1 || n == 2) {
            this.srpLogin.getSidAuthAccountChange(publicExposedFunctions);
        }
        throw new LoginException("[BNET] Unable to login in with type " + n);
    }

    public BnetPacket checkPasswordChange(PublicExposedFunctions publicExposedFunctions, BnetPacket bnetPacket) throws LoginException, PluginException {
        int n = bnetPacket.removeDWord();
        if (n == 0) {
            throw new LoginException("[BNET] Password change failed");
        }
        publicExposedFunctions.systemMessage(1, "[BNET] Password change successful");
        publicExposedFunctions.putLocalSetting(this.prefSection, "password", publicExposedFunctions.getLocalSetting(this.prefSection, "password change"));
        publicExposedFunctions.putLocalSetting(this.prefSection, "password change", "");
        switch ((Integer)publicExposedFunctions.getLocalVariable((Object)"loginType")) {
            case 0: {
                return SidLogonResponse2.getOutgoing(publicExposedFunctions);
            }
            case 1: 
            case 2: {
                return this.srpLogin.getSidAuthAccountLogon(publicExposedFunctions);
            }
        }
        throw new LoginException("[BNET] Unable to login in with type " + (Integer)publicExposedFunctions.getLocalVariable((Object)"loginType"));
    }

    public BnetPacket getEnterChat(PublicExposedFunctions publicExposedFunctions) {
        BnetPacket bnetPacket = new BnetPacket(10);
        bnetPacket.addNTString(publicExposedFunctions.getLocalSettingDefault(this.prefSection, "username", "not.iago.x86"));
        bnetPacket.addNTString("");
        return bnetPacket;
    }

    public BnetPacket getJoinHomeChannel(PublicExposedFunctions publicExposedFunctions) {
        BnetPacket bnetPacket = new BnetPacket();
        bnetPacket.setCode((byte)12);
        bnetPacket.addDWord(2);
        bnetPacket.addNTString(publicExposedFunctions.getLocalSettingDefault(this.prefSection, "home channel", "op x86"));
        return bnetPacket;
    }
}

