/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SweepBan;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback,
PacketCallback,
EventCallback {
    private PublicExposedFunctions out;
    private boolean sweepBan = false;
    private boolean sweepBanIp = false;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "sweepban", 1, true, "ON", "<channel>", "Bans everybody in the selected channel. Two channels may not be sweepbanned at the same time.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "sweepbanip", 1, true, "ON", "<channel>", "Bans everybody in the selected channel based on their ip. Two channels may not be sweepbanned at the same time.", null);
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 38, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "SweepBan";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Provides sweep-ban functionality";
    }

    public String getLongDescription() {
        return "Adds the .sweepban command which lets a user with access ban everybody in a channel";
    }

    public Properties getDefaultSettingValues() {
        return new Properties();
    }

    public Properties getSettingsDescription() {
        return new Properties();
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (stringArray.length == 0) {
            throw new CommandUsedImproperly("Sweepban requires a parameter (the channel name)", string, string2);
        }
        if (string2.equalsIgnoreCase("sweepban")) {
            this.sweepBan = true;
        } else if (string2.equalsIgnoreCase("sweepbanip")) {
            this.sweepBanIp = true;
        }
        this.out.sendTextUser(string, "Sweeping channel " + stringArray[0], n);
        BnetPacket bnetPacket = new BnetPacket(14);
        bnetPacket.addNTString("/who " + stringArray[0]);
        this.out.sendPacket((Buffer)bnetPacket);
        BnetPacket bnetPacket2 = new BnetPacket(38);
        bnetPacket2.addDWord(1);
        bnetPacket2.addDWord(1);
        bnetPacket2.addDWord(this.getName().hashCode());
        bnetPacket2.addNTString("iago");
        bnetPacket2.addNTString("profile\\sex");
        this.out.sendPacket((Buffer)bnetPacket2);
        this.out.systemMessage(1, "Sweepban enabled");
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws PluginException {
        if (bnetPacket.getCode() == 38) {
            bnetPacket.removeDWord();
            bnetPacket.removeDWord();
            if (bnetPacket.removeDWord() == this.getName().hashCode()) {
                this.sweepBan = false;
                this.sweepBanIp = false;
                this.out.systemMessage(1, "Sweepban disabled");
            }
        }
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (!this.sweepBan && !this.sweepBanIp) {
            return;
        }
        if (!string2.matches("[^ ]+|[^ ]+, [^ ]+")) {
            return;
        }
        String[] stringArray = string2.split(", ");
        if (stringArray.length < 1 || stringArray.length > 2) {
            this.out.systemMessage(4, "Improper sweepban response detected");
            return;
        }
        this.ban(stringArray[0]);
        if (stringArray.length == 2) {
            this.ban(stringArray[1]);
        }
    }

    private void ban(String string) throws IOException {
        if (this.out.dbHasAny(string, "FS", true)) {
            this.out.systemMessage(1, "Not sweepbanning " + string);
            return;
        }
        this.out.systemMessage(1, "Sweepbanning " + string);
        if (this.sweepBanIp) {
            this.out.sendTextPriority("/squelch " + string, -50);
        } else {
            this.out.sendTextPriority("/ban " + string + " Sweepban", -50);
        }
        if (string.matches("\\[.*\\]")) {
            string = string.substring(1, string.length() - 1);
            this.out.systemMessage(1, "Sweepbanning " + string);
            if (this.sweepBanIp) {
                this.out.sendTextPriority("/squelch " + string, -50);
            } else {
                this.out.sendTextPriority("/ban " + string + " Sweepban", -50);
            }
        }
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        return bnetPacket;
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
    }
}

