/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Logging;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.LoginException;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.ErrorCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.OutgoingTextCallback;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.plugin_interfaces.SystemMessageCallback;
import com.javaop.util.BnetEvent;
import com.javaop.util.BnetPacket;
import com.javaop.util.RelativeFile;
import com.javaop.util.Timestamp;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements EventCallback,
OutgoingTextCallback,
SystemMessageCallback,
ErrorCallback,
PacketCallback {
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
        pluginCallbackRegister.registerOutgoingTextPlugin((OutgoingTextCallback)this, null);
        pluginCallbackRegister.registerSystemMessagePlugin((SystemMessageCallback)this, 1, 8, null);
        pluginCallbackRegister.registerErrorPlugin((ErrorCallback)this, null);
        if (publicExposedFunctions.getLocalSettingDefault(this.getName(), "Log packets", "false").equalsIgnoreCase("true")) {
            pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 0, packetConstants.length, (Object)"Incoming");
            pluginCallbackRegister.registerOutgoingPacketPlugin((PacketCallback)this, 0, packetConstants.length, (Object)"Outgoing");
        }
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Logging";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Logs to a file";
    }

    public String getLongDescription() {
        return "Logs all chat, events, and errors to a file. ";
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Log packets", "Logs incoming and outgoing packets.  Use this to submit a connection problem, but be warned: it'll generate HUGE logs.  Bot must be restarted for this to take effect (simply because of the overhead, it slows things down a little)");
        properties.setProperty("Log join/leave", "Logs notifications when users join or leave the channel");
        properties.setProperty("Log format", "The format of the logs.  Either \"text\", \"html\" or \"bb\" (bb is for posting on forums)");
        properties.setProperty("Log file", "The full path to where you want the logs to go.  %d will be expanded to the date and %n will be expanded to the bot's name.  If %d is used, you will get a different file for each day.");
        return properties;
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Log packets", "false");
        properties.setProperty("Log join/leave", "false");
        properties.setProperty("Log file", new RelativeFile("logs/%n-%d.html").getAbsolutePath());
        properties.setProperty("Log format", "html");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("Log join/leave") || string.equalsIgnoreCase("Log packets")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("Log format")) {
            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"html", "text", "bb"});
            jComboBox.setSelectedItem(string2);
            return jComboBox;
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    private void addToLog(String string) {
        try {
            String string2 = this.out.getLocalSettingDefault(this.getName(), "Log format", "html");
            String string3 = this.out.getLocalSettingDefault(this.getName(), "Log file", new RelativeFile("logs/%n-%d.html").getAbsolutePath());
            string3 = string3.replaceAll("%n", this.out.getName());
            string3 = string3.replaceAll("%d", Timestamp.getDate());
            new File(string3).getParentFile().mkdirs();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string3, true)));
            if (string2.equalsIgnoreCase("html")) {
                printWriter.println("<b><font color=\"white\">" + Timestamp.getTimestamp() + "</font></b> " + string + "<br>");
            } else if (string2.equalsIgnoreCase("bb")) {
                printWriter.println("[b][color=white]" + Timestamp.getTimestamp() + "[/color][/b]" + string);
            } else {
                printWriter.println(Timestamp.getTimestamp() + string);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to open log file for writing!");
            iOException.printStackTrace();
        }
    }

    private String sanitizeHtml(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\n", "<br>");
        return string;
    }

    private String sanitizeBB(String string) {
        return string;
    }

    private String sanitize(String string) {
        String string2 = this.out.getLocalSettingDefault(this.getName(), "Log format", "html");
        if (string2.equalsIgnoreCase("html")) {
            return this.sanitizeHtml(string);
        }
        if (string2.equalsIgnoreCase("bb")) {
            return this.sanitizeBB(string);
        }
        return string;
    }

    private String format(Object object, String string) {
        String string2 = object + "";
        String string3 = this.out.getLocalSettingDefault(this.getName(), "Log format", "html");
        string2 = this.sanitize(string2);
        if (string3.equalsIgnoreCase("html")) {
            return "<font color=\"" + string + "\">" + string2 + "</font>";
        }
        if (string3.equalsIgnoreCase("bb")) {
            return "[color=" + string + "]" + string2 + "[/color]";
        }
        return string2;
    }

    public void talk(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format("<" + string + "> ", "yellow") + this.format(string2, "white"));
    }

    public void emote(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format("<" + string + " " + string2, "yellow"));
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format("<From: " + string + "> " + string2, "gray"));
    }

    public void whisperTo(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format("<To: " + string + "> " + string2, "gray"));
    }

    public void userShow(String string, String string2, int n, int n2) throws PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "Log join/leave", "true").equalsIgnoreCase("true")) {
            this.addToLog(this.format(string + " is in the channel", "green"));
        }
    }

    public void userJoin(String string, String string2, int n, int n2) throws PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "Log join/leave", "true").equalsIgnoreCase("true")) {
            this.addToLog(this.format(string + " has joined the channel", "green"));
        }
    }

    public void userLeave(String string, String string2, int n, int n2) throws PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "Log join/leave", "true").equalsIgnoreCase("true")) {
            this.addToLog(this.format(string + " has left the channel", "green"));
        }
    }

    public void userFlags(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format(string + " has had a flag update", "green"));
    }

    public void error(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format(string2, "red"));
    }

    public void info(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format(string2, "yellow"));
    }

    public void broadcast(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format(string2, "orange"));
    }

    public void channel(String string, String string2, int n, int n2) throws PluginException {
        this.addToLog(this.format("Joining: ", "green") + this.format(string2, "white"));
    }

    public String queuingText(String string, Object object) {
        return string;
    }

    public void queuedText(String string, Object object) {
    }

    public String nextInLine(String string, Object object) {
        return string;
    }

    public long getDelay(String string, Object object) {
        return 0L;
    }

    public boolean sendingText(String string, Object object) {
        return true;
    }

    public void sentText(String string, Object object) {
        this.addToLog(this.format("<" + this.out.getLocalVariable((Object)"username") + "> ", "cyan") + this.format(string, "white"));
    }

    public void systemMessage(int n, String string, Object object) {
        this.addToLog(this.format(errorLevelConstants[n] + ": " + string, "gray"));
    }

    public void showMessage(String string, Object object) {
        this.addToLog(this.format(string, "gray"));
    }

    public void loginException(LoginException loginException, Object object) {
        this.displayError((Throwable)loginException);
    }

    public void unknownPacketReceived(BnetPacket bnetPacket, Object object) {
        this.addToLog(this.format("Unknown packet received:\n" + bnetPacket, "blue"));
    }

    public void unknownEventReceived(BnetEvent bnetEvent, Object object) {
        this.addToLog(this.format("Unknown event received:\n" + bnetEvent, "blue"));
    }

    public void displayError(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        this.addToLog(this.format(throwable, "red"));
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            this.addToLog(this.format(stackTraceElementArray[i].toString(), "red"));
        }
    }

    public void ioException(IOException iOException, Object object) {
        this.displayError(iOException);
    }

    public void unknownException(Exception exception, Object object) {
        this.displayError(exception);
    }

    public void error(Error error, Object object) {
        this.displayError(error);
    }

    public void pluginException(PluginException pluginException, Object object) {
        this.displayError((Throwable)pluginException);
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) throws PluginException {
        return bnetPacket;
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws PluginException {
        if (bnetPacket.getCode() == 37 || bnetPacket.getCode() == 0) {
            return;
        }
        if (bnetPacket.getCode() == 81 || bnetPacket.getCode() == 58) {
            this.addToLog(this.format(object + ": " + packetConstants[bnetPacket.getCode()] + " not logged.", "orange"));
        } else {
            this.addToLog(this.format(object + ": [" + packetConstants[bnetPacket.getCode()] + "]\n" + bnetPacket.toString(), "orange"));
        }
    }
}

