/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Forwarding;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements EventCallback,
CommandCallback {
    private boolean forward;
    private boolean forwardAll;
    private String forwardTo;
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "forwardoff", 0, false, "N", "", "Removes message forwarding.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "forwardwhispers", 1, false, "N", "[user]", "Forwards whispers in the channel to the specified user.  If none is specified, forwards to the user who used the command.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "forwardall", 1, false, "N", "[user]", "Forwards all information from the channel to the specifed user.  If none is specified, forwards to the user who used the command.", null);
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Forwarding";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getLongDescription() {
        return "Can forward all messages or whispered messages to the specified user.  This is done at run-time, if the plugin is reloaded the forwarding is disabled.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, string + ": " + string2, 0, -50);
        }
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, "<" + string + " " + string2 + ">", 0, -50);
        }
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward) {
            this.out.sendTextUserPriority(this.forwardTo, "From " + string + ": " + string2, 0, -50);
        }
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, "Joined: " + string, 0, -50);
        }
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, "Left: " + string, 0, -50);
        }
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, "Error: " + string2, 0, -50);
        }
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, "Info: " + string2, 0, -50);
        }
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, "Broadcast: " + string2, 0, -50);
        }
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.forward && this.forwardAll) {
            this.out.sendTextUserPriority(this.forwardTo, "Channel: " + string2, 0, -50);
        }
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("forwardoff")) {
            this.forward = false;
        } else if (string2.equalsIgnoreCase("forwardwhispers")) {
            this.forward = true;
            this.forwardAll = false;
            this.forwardTo = stringArray.length > 0 ? stringArray[0] : string;
            this.out.sendTextUser(string, "Forwarding whispers to " + this.forwardTo, n);
        } else if (string2.equalsIgnoreCase("forwardall")) {
            this.forward = true;
            this.forwardAll = true;
            this.forwardTo = stringArray.length > 0 ? stringArray[0] : string;
            this.out.sendTextUser(string, "Forwarding all messages to " + this.forwardTo, n);
        } else {
            this.out.sendTextUser(string, "Error: unknown command in Fowarding.  Please report on forums.", 0);
        }
    }
}

