/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Commands;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.PersistantMap;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements EventCallback,
CommandCallback {
    private PublicExposedFunctions out;
    private static StaticExposedFunctions funcs;
    private PersistantMap customFlags;

    public void load(StaticExposedFunctions staticExposedFunctions) {
        funcs = staticExposedFunctions;
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        this.customFlags = funcs.getCustomFlags(publicExposedFunctions.getName());
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "loud", 2, false, "ANL", "<command/params>", "Runs a command, sending its output to the channel, regardless of what the 'loud' setting is", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "quiet", 2, false, "ANL", "<command/params>", "Runs a command, whispering back the result, regardless of what the 'loud' setting is", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "silent", 2, false, "ANL", "<command/params>", "Runs a command, sending output only to the console, regardless of what the 'loud' setting is", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "setflagsfor", 2, false, "N", "<command> [flags]", "Sets the flags required to use a command on this bot to the specified flags.  If [flags] isn't included, it is reset to defaults.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "getflagsfor", 1, false, "AN", "<command>", "Retrieves the customized flags required to user a command on this bot.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "settrigger", 1, false, "N", "[new trigger]", "Sets the trigger to the specified value. The trigger can be 0 or more characters, although a 0-character trigger gets very annoying", null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Commands";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "This plugin parses commands sent by users in the channel";
    }

    public String getLongDescription() {
        return "This plugin looks after checking for the trigger and raising commands.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("trigger", ".");
        properties.setProperty("loud", "quiet");
        properties.setProperty("stacked messages", "true");
        properties.setProperty("whispers always command", "false");
        properties.setProperty("?trigger requires flags", "true");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("trigger", "The character or characters that, when put at the beginning of a user's message, makes it a command. This can be blank.");
        properties.setProperty("loud", "Whether or not to give responses to commands out loud.  Values are \"loud\", \"quiet\", \"loud (no name)\", or \"silent (not recommended)\", ");
        properties.setProperty("stacked messages", "Whether or not to allow stacking messages with semicolons (like ?say a;say b;say c;say d)");
        properties.setProperty("whispers always command", "If this is set to true, then anything whispered to the bot will be interpreted as a command.  This is handy for ops, but annoying for chatting (and can cause infinite 'command not found' loops)");
        properties.setProperty("?trigger requires flags", "If this is enabled, a user must have A, N, or L flag to use ?trigger");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("stacked messages") || string.equalsIgnoreCase("whispers always command") || string.equalsIgnoreCase("?trigger requires flags")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("loud")) {
            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"quiet", "loud", "loud (no name)", "silent (not recommended)"});
            jComboBox.setSelectedItem(string2);
            return jComboBox;
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public boolean isRequiredPlugin() {
        return true;
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.doTrigger(string, string2)) {
            return;
        }
        if ((string2 = this.shouldRun(string2)) != null) {
            this.doCommand(string, string2);
        }
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.doTrigger(string, string2)) {
            return;
        }
        if ((string2 = this.shouldRun(string2)) != null) {
            this.doCommand(string, string2);
        }
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.doTrigger(string, string2) || this.doTrigger(string, "?" + string2)) {
            return;
        }
        String string3 = this.shouldRun(string2);
        if (string3 != null) {
            this.doCommand(string, string3, 0);
        } else if (string2.length() > 2 && this.out.getLocalSettingDefault(this.getName(), "whispers always command", "false").equalsIgnoreCase("true")) {
            this.doCommand(string, string2, 0);
        }
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    private boolean doTrigger(String string, String string2) throws IOException, PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "?trigger requires flags", "true").equalsIgnoreCase("true") && !this.out.dbHasAny(string, "ANL", true)) {
            return false;
        }
        if (!string2.equalsIgnoreCase("?trigger")) {
            return false;
        }
        this.out.sendTextUserPriority(string, "The trigger is " + this.out.getLocalSetting(this.getName(), "trigger"), 0, -110);
        return true;
    }

    private String shouldRun(String string) {
        String string2 = this.out.getLocalSettingDefault(this.getName(), "trigger", ".");
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return null;
    }

    private void doCommand(String string, String string2) throws IOException {
        this.doCommand(string, string2, this.getLoudness());
    }

    private void doCommand(String string, String string2, int n) throws IOException {
        if (this.out.getLocalSettingDefault(this.getName(), "stacked messages", "true").equalsIgnoreCase("true")) {
            string2 = string2.replaceAll("\\\\;", "::SEMICOLON::").trim();
            String[] stringArray = string2.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].trim().split(" ", 2);
                String string3 = stringArray2[0].trim().replaceAll("::SEMICOLON::", ";");
                String string4 = stringArray2.length == 2 ? stringArray2[1].trim() : "";
                this.runCommand(string, string3, string4, n);
            }
        } else {
            String[] stringArray = string2.trim().split(" ", 2);
            String string5 = stringArray[0].trim();
            String string6 = stringArray.length == 2 ? stringArray[1].trim() : "";
            this.runCommand(string, string5, string6, n);
        }
    }

    private void runCommand(String string, String string2, String string3, int n) throws IOException {
        this.out.raiseCommand(string, string2, string3, n, true);
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("settrigger")) {
            String string3 = stringArray.length == 1 ? stringArray[0] : "";
            this.out.putLocalSetting(this.getName(), "trigger", string3);
            this.out.sendTextUser(string, "Trigger => " + string3, n);
        } else if (string2.equalsIgnoreCase("setflagsfor")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("setflagsfor requires at least one parameter", string, string2);
            }
            if (!this.out.getCommandOf(stringArray[0]).equalsIgnoreCase(stringArray[0])) {
                this.out.sendTextUser(string, "Error: that is an alias, not a command. Try using '" + this.out.getCommandOf(stringArray[0]) + "' instead.", 0);
                return;
            }
            String string4 = this.customFlags.getNoWrite(null, stringArray[0], "<n/a>");
            if (stringArray.length == 1 || stringArray[1].length() == 0) {
                this.customFlags.remove(null, stringArray[0]);
            } else {
                stringArray[1] = stringArray[1].toUpperCase().replaceAll("\\W", "");
                this.customFlags.set(null, stringArray[0], stringArray[1]);
            }
            this.out.sendTextUser(string, "Flags for '" + stringArray[0] + "': " + string4 + " => " + this.customFlags.getNoWrite(null, stringArray[0], "<n/a>"), n);
        } else if (string2.equalsIgnoreCase("getflagsfor")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("getflagsfor requires at least one parameter", string, string2);
            }
            if (!this.out.getCommandOf(stringArray[0]).equalsIgnoreCase(stringArray[0])) {
                this.out.sendTextUser(string, "Error: that is an alias, not a command.  Try using '" + this.out.getCommandOf(stringArray[0]) + "' instead.", 0);
                return;
            }
            this.out.sendTextUser(string, "Flags for '" + stringArray[0] + "' => " + this.customFlags.getNoWrite(null, stringArray[0], "<n/a>"), n);
        }
    }

    private int getLoudness() {
        String string = this.out.getLocalSettingDefault(this.getName(), "loud", "info");
        if (string.equalsIgnoreCase("packet")) {
            return 0;
        }
        if (string.equalsIgnoreCase("debug")) {
            return 1;
        }
        if (string.equalsIgnoreCase("info")) {
            return 2;
        }
        if (string.equalsIgnoreCase("notice")) {
            return 3;
        }
        if (string.equalsIgnoreCase("warning")) {
            return 4;
        }
        if (string.equalsIgnoreCase("error")) {
            return 5;
        }
        if (string.equalsIgnoreCase("critical")) {
            return 6;
        }
        if (string.equalsIgnoreCase("alert")) {
            return 7;
        }
        if (string.equalsIgnoreCase("emergency")) {
            return 8;
        }
        return 2;
    }
}

