/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.UserInformation;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.PersistantMap;
import com.javaop.util.RelativeFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback,
EventCallback,
ActionListener {
    private PersistantMap allSeen;
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "seen", 1, false, "ALN", "<username>", "Shows whether the bot has seen the specified user", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "lastseen", 1, false, "ALN", "<username>", "Shows the last time the specified user was seen", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "firstseen", 1, false, "ALN", "<username>", "Shows the first time the specified user was seen", null);
        this.allSeen = new PersistantMap((File)new RelativeFile(publicExposedFunctions.getName() + ".seen"), "This is the last-seen database.  It keeps track of the last time a person was seen.");
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "UserInformation";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getLongDescription() {
        return "This plugin stores and displays long-term type information about users such as when they were last seen and how often they are seen.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    private void seen(String string) {
        String string2 = this.allSeen.getNoWrite(string, "Last seen", "");
        if (string2.length() == 0) {
            this.allSeen.set(string, "First seen", new Date().toString());
        }
        this.allSeen.set(string, "Last seen", new Date().toString());
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (stringArray.length == 0) {
            throw new CommandUsedImproperly("The 'seen' commands require two parameters", string, string2);
        }
        String string3 = stringArray[0];
        if (string2.equalsIgnoreCase("seen")) {
            if (this.allSeen.contains(string3, "First seen")) {
                this.out.sendTextUser(string, "User '" + string3 + "' has been seen", n);
            } else {
                this.out.sendTextUser(string, "User '" + string3 + "' has not been seen", n);
            }
        } else if (string2.equalsIgnoreCase("lastseen")) {
            this.out.sendTextUser(string, "User '" + string3 + "' was last seen: " + this.allSeen.getNoWrite(string3, "Last seen", "Never"), n);
        } else if (string2.equalsIgnoreCase("firstseen")) {
            this.out.sendTextUser(string, "User '" + string3 + "' was first seen: " + this.allSeen.getNoWrite(string3, "First seen", "Never"), n);
        } else {
            this.out.sendTextUser(string, "Error: unknown command used in UserInformation.  Please contact iago.", 0);
        }
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.seen(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(null, "Item = " + actionEvent.getSource() + "; user = " + actionEvent.getActionCommand());
    }
}

