/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.AntiFlood;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.OutgoingTextCallback;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.gui.JTextFieldNumeric;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements OutgoingTextCallback,
CommandCallback,
PacketCallback {
    private long lastSent = System.currentTimeMillis();
    private PublicExposedFunctions out;
    private int credits;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerOutgoingTextPlugin((OutgoingTextCallback)this, null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "clearqueue", 0, false, "AN", "", "Clears the current queue of outgoing messages, and resets timers.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "testqueue", 0, false, "M", "<size>", "Sends 250 messages of the specified size", null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 19, null);
        this.credits = Integer.parseInt(publicExposedFunctions.getLocalSettingDefault(this.getName(), "starting credits", "750"));
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "AntiFlood";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "http://www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Provides an anti-flood algorithm.";
    }

    public String getLongDescription() {
        return "This is an anti-flood algorithm based on one that I wrote, which was based loosely on Adron's.  I've never flooded off with this algorithm before, but I hear that it gets unbearably slow after awhile.  It works well for my uses, though, if anybody has a better one that they feel like porting to Java, be my guest and I'll include it in releases.";
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.put("debug", "This will show the current delay and the current number of credits each message, in case you want to find-tune it.");
        properties.put("prevent flooding", "It's a very bad idea to turn this off -- if you do, it won't try to stop you from flooding.");
        properties.put("cost - packet", "This is the amount of credits 'paid' for each sent packet.");
        properties.put("cost - byte", "WARNING: I don't recommend changing ANY of the settings for anti-flood.  But if you want to tweak, you can.  This is the number of credits 'paid' for each byte.");
        properties.put("cost - byte over threshold", "This is the amount of credits 'paid' for each byte after the threshold is reached.");
        properties.put("starting credits", "This is the number of credits you start with.");
        properties.put("threshold bytes", "This is the length of a message that triggers the treshold (extra delay).");
        properties.put("max credits", "This is the maximum number of credits that the bot can have.");
        properties.put("credit rate", "This is the amount of time (in milliseconds) it takes to earn one credit.");
        return properties;
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.put("debug", "false");
        properties.put("prevent flooding", "true");
        properties.put("cost - packet", "250");
        properties.put("cost - byte", "15");
        properties.put("cost - byte over threshold", "20");
        properties.put("starting credits", "200");
        properties.put("threshold bytes", "65");
        properties.put("max credits", "800");
        properties.put("credit rate", "10");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("debug") || string.equalsIgnoreCase("prevent flooding")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("cost - packet") || string.equalsIgnoreCase("cost - byte") || string.equalsIgnoreCase("cost - byte over threshold") || string.equalsIgnoreCase("starting credits") || string.equalsIgnoreCase("thresholdBytes") || string.equalsIgnoreCase("max credits") || string.equalsIgnoreCase("credit rate")) {
            return new JTextFieldNumeric(string2);
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public boolean isRequiredPlugin() {
        return true;
    }

    public String queuingText(String string, Object object) {
        return string;
    }

    public void queuedText(String string, Object object) {
    }

    public String nextInLine(String string, Object object) {
        return string;
    }

    public long getDelay(String string, Object object) {
        if (this.out.getLocalSettingDefault(this.getName(), "prevent flooding", "true").equals("false")) {
            return 0L;
        }
        boolean bl = this.out.getLocalSettingDefault(this.getName(), "debug", "false").equalsIgnoreCase("true");
        int n = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "cost - packet", "250"));
        int n2 = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "cost - byte", "15"));
        int n3 = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "cost - byte over threshold", "20"));
        int n4 = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "threshold bytes", "65"));
        int n5 = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "max credits", "800"));
        int n6 = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "credit rate", "10"));
        if (this.credits < n5) {
            this.credits = (int)((long)this.credits + (System.currentTimeMillis() - this.lastSent) / (long)n6);
            if (this.credits > n5) {
                if (bl) {
                    this.out.systemMessage(1, "Maximum anti-flood credits reached (" + n5 + ")");
                }
                this.credits = n5;
            }
        }
        this.lastSent = System.currentTimeMillis();
        int n7 = n2;
        if (string.length() > n4) {
            n2 = n3;
        }
        int n8 = n + n7 * string.length();
        if (bl) {
            this.out.systemMessage(1, "Cost for this packet = " + n8);
        }
        int n9 = 0;
        if (this.credits < 0) {
            n9 = -this.credits * n6;
        }
        this.credits -= n8;
        if (bl) {
            this.out.systemMessage(1, "Remaining credits: " + this.credits + "; Delay: " + n9);
        }
        return n9;
    }

    public boolean sendingText(String string, Object object) {
        return true;
    }

    public void sentText(String string, Object object) {
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("clearqueue")) {
            this.credits = 0;
            this.lastSent = System.currentTimeMillis();
            this.out.clearQueue();
            this.out.sendTextUser(string, "Queue cleared", n);
        } else if (string2.equalsIgnoreCase("testqueue")) {
            int n2;
            int n3 = 15;
            if (stringArray.length > 0) {
                n3 = Integer.parseInt(stringArray[0]);
            }
            String string3 = "";
            for (n2 = 0; n2 < n3; ++n2) {
                string3 = string3 + 'a';
            }
            for (n2 = 0; n2 < 250; ++n2) {
                this.out.sendText(string3);
            }
        } else {
            this.out.sendTextUser(string, "An error occurred in the AntiFlood plugin - unknown command -- please contact iago.", n);
        }
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        return bnetPacket;
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        if (bnetPacket.getCode() == 19) {
            this.out.systemMessage(5, "You flooded off Battle.net!  If you HAVEN'T tweaked the Anti-flood settings, please send iago the last commands/conversation the bot had!");
        }
    }
}

