/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.ConnectionCommands;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback {
    private PublicExposedFunctions out;
    private static StaticExposedFunctions staticFuncs;

    public void load(StaticExposedFunctions staticExposedFunctions) {
        staticFuncs = staticExposedFunctions;
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "disconnect", 0, false, "C", "", "Disconnects the bot from Battle.net.  Not usually a good idea.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "quit", 0, false, "U", "", "Closes the bot, along with all instances.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "reconnect", 0, false, "C", "", "Reconnects to Battle.net", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "close", 0, false, "C", "", "Disconnects and cleans up the current instance", null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "ConnectionCommands";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Commands for connection-related things";
    }

    public String getLongDescription() {
        return "Commands that allow the user to disconnect, reconnect, and quit the bot.";
    }

    public String getComment() {
        return "";
    }

    public Properties getDefaultSettingValues() {
        return new Properties();
    }

    public Properties getSettingsDescription() {
        return new Properties();
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("disconnect")) {
            this.out.systemMessage(4, "Disconnecting");
            this.out.disconnect();
        } else if (string2.equalsIgnoreCase("reconnect")) {
            this.out.systemMessage(4, "Reconnecting");
            this.out.reconnect();
        } else if (string2.equalsIgnoreCase("quit")) {
            this.out.systemMessage(4, "Quitting");
            System.exit(0);
        } else if (string2.equalsIgnoreCase("close")) {
            this.out.systemMessage(4, "Closing");
            try {
                staticFuncs.botStop(this.out.getName());
            }
            catch (Exception exception) {
                this.out.sendTextUser(string, "Unable to kill the instance: " + exception, n);
            }
        }
    }
}

