/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Alias;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback {
    private PublicExposedFunctions pubFuncs;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.pubFuncs = this.pubFuncs;
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "addalias", 2, false, "N", "<alias> <command> [parameters]", "Adds an alias to the specified command. Parameters may contain: %u for user, %v for bot version, and %n for bot name.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "removealias", 0, false, "N", "<alias(es)>", "Removes an alias", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "removealiases", 1, false, "N", "<command>", "Removes all aliases pointing to the command. Remember that default aliases will re-load when the bot starts.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "listaliases", 1, false, "LAN", "<command>", "Lists all aliases to the specified command", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "getalias", 1, false, "LAN", "<alias>", "Shows the command that this alias points to", null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Alias";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "javaop.googlecode.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Provides aliasing for commands";
    }

    public String getLongDescription() {
        return "Lets users specify custom aliases for commands.";
    }

    public Properties getDefaultSettingValues() {
        return new Properties();
    }

    public Properties getSettingsDescription() {
        return new Properties();
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("addalias")) {
            if (stringArray.length < 2) {
                throw new CommandUsedImproperly("addalias requires at least 2 parameters", string, string2);
            }
            this.pubFuncs.addAlias(stringArray[1], stringArray[0]);
            this.pubFuncs.sendTextUser(string, stringArray[0] + " => " + stringArray[1], n);
        } else if (string2.equalsIgnoreCase("removealias")) {
            if (stringArray.length < 1) {
                throw new CommandUsedImproperly("removealias requires at least 1 parameter", string, string2);
            }
            StringBuffer stringBuffer = new StringBuffer("Removed: ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i] + ", ");
                this.pubFuncs.removeAlias(stringArray[i]);
            }
            this.pubFuncs.sendTextUser(string, stringBuffer.substring(0, stringBuffer.length() - 2), n);
        } else if (string2.equalsIgnoreCase("removealiases")) {
            if (stringArray.length != 1) {
                throw new CommandUsedImproperly("removealiases requires 1 parameter", string, string2);
            }
            String[] stringArray2 = this.pubFuncs.getAliasesOf(stringArray[0]);
            if (stringArray2.length == 0) {
                this.pubFuncs.sendTextUser(string, "No aliases found for command " + stringArray[0], -50);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("Removed: ");
            for (int i = 0; i < stringArray2.length; ++i) {
                this.pubFuncs.removeAlias(stringArray2[i]);
                stringBuffer.append(stringArray2[i] + ", ");
            }
            this.pubFuncs.sendTextUser(string, stringBuffer.substring(0, stringBuffer.length() - 2).toString(), n);
        } else if (string2.equalsIgnoreCase("listaliases")) {
            if (stringArray.length != 1) {
                throw new CommandUsedImproperly("listaliases requires 1 parameter", string, string2);
            }
            String[] stringArray3 = this.pubFuncs.getAliasesOf(stringArray[0]);
            if (stringArray3.length == 0) {
                this.pubFuncs.sendTextUser(string, "No aliases found for command " + stringArray[0], -50);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(stringArray[0] + ": ");
            for (int i = 0; i < stringArray3.length; ++i) {
                stringBuffer.append(stringArray3[i] + ", ");
            }
            this.pubFuncs.sendTextUser(string, stringBuffer.substring(0, stringBuffer.length() - 2).toString(), n);
        } else if (string2.equalsIgnoreCase("getalias")) {
            if (stringArray.length != 1) {
                throw new CommandUsedImproperly("getalias requires 1 parameter", string, string2);
            }
            String string3 = this.pubFuncs.getCommandOf(stringArray[0]);
            if (!string3.equalsIgnoreCase(stringArray[0])) {
                this.pubFuncs.sendTextUser(string, stringArray[0] + " => " + string3, n);
            } else {
                this.pubFuncs.sendTextUser(string, "Alias not found.", n);
            }
        } else {
            this.pubFuncs.sendTextUser(string, "Error in Alias plugin -- please report on website.", n);
        }
    }
}

