/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.ConsoleDisplay;

import com.javaop.ConsoleDisplay.Output;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.LoginException;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.ErrorCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.OutgoingTextCallback;
import com.javaop.plugin_interfaces.SystemMessageCallback;
import com.javaop.util.BnetEvent;
import com.javaop.util.BnetPacket;
import com.javaop.util.ColorConstants;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements SystemMessageCallback,
EventCallback,
OutgoingTextCallback,
ErrorCallback {
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerSystemMessagePlugin((SystemMessageCallback)this, 1, 8, null);
        pluginCallbackRegister.registerErrorPlugin((ErrorCallback)this, null);
        pluginCallbackRegister.registerOutgoingTextPlugin((OutgoingTextCallback)this, null);
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public void systemMessage(int n, String string, Object object) {
        switch (n) {
            case 1: {
                Output.output(this.out.getName(), "\u001b[2;32m" + errorLevelConstants[n] + ": " + string, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
                break;
            }
            case 2: {
                Output.output(this.out.getName(), "\u001b[1;33m" + errorLevelConstants[n] + ": " + string, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
                break;
            }
            default: {
                Output.output(this.out.getName(), "\u001b[0;31m" + errorLevelConstants[n] + ": " + string, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
            }
        }
    }

    public void showMessage(String string, Object object) {
        string = ColorConstants.removeColors((String)string);
        Output.output(this.out.getName(), "\u001b[0;36m" + string, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void userShow(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;32m" + string + " is in the channel (" + string2 + ").", this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void userJoin(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;32m" + string + " has joined the channel (" + string2 + ").", this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void userLeave(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;32m" + string + " has left the channel.", this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void whisperFrom(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;30m<From: " + string + "> " + string2, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void talk(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;33m<" + string + "> " + "\u001b[0;37m" + string2, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void broadcast(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;33m*** BROADCAST: " + string2, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void channel(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;32mJoining " + string2, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void userFlags(String string, String string2, int n, int n2) {
    }

    public void whisperTo(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;30m<To: " + string + "> " + string2, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void error(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;31m" + string2, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void info(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;33m" + string2, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void emote(String string, String string2, int n, int n2) {
        Output.output(this.out.getName(), "\u001b[1;33m<" + string + " " + string2 + ">", this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public String queuingText(String string, Object object) {
        return string;
    }

    public void queuedText(String string, Object object) {
    }

    public String nextInLine(String string, Object object) {
        return string;
    }

    public long getDelay(String string, Object object) {
        return 0L;
    }

    public boolean sendingText(String string, Object object) {
        return true;
    }

    public void sentText(String string, Object object) {
        Output.output(this.out.getName(), "\u001b[1;36m<" + this.out.getLocalVariable((Object)"username") + "> " + "\u001b[0;37m" + string, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void ioException(IOException iOException, Object object) {
        this.displayError(this.out.getName(), iOException, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void unknownException(Exception exception, Object object) {
        this.displayError(this.out.getName(), exception, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void error(Error error, Object object) {
        this.displayError(this.out.getName(), error, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void pluginException(PluginException pluginException, Object object) {
        this.displayError(this.out.getName(), (Throwable)pluginException, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void loginException(LoginException loginException, Object object) {
        Output.output(this.out.getName(), "\u001b[1;31mLogin Exception:", this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
        this.displayError(this.out.getName(), (Throwable)loginException, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void unknownPacketReceived(BnetPacket bnetPacket, Object object) {
        Output.output(this.out.getName(), "\u001b[2;34mUnknown packet received:", this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
        Output.output(this.out.getName(), "\u001b[2;34m" + bnetPacket, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void unknownEventReceived(BnetEvent bnetEvent, Object object) {
        Output.output(this.out.getName(), "\u001b[2;34mUnknown event received:", this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
        Output.output(this.out.getName(), "\u001b[2;34m" + bnetEvent, this.out.getLocalSettingDefault(this.getName(), "colors", "true").equals("true"));
    }

    public void displayError(String string, Throwable throwable, boolean bl) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Output.output(string, "\u001b[1;31m" + throwable.toString(), bl);
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            Output.output(string, "\u001b[0;31m" + stackTraceElementArray[i], bl);
        }
    }

    public String getName() {
        return "ConsoleDisplay";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "http://www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Displays messages to the console, optionally in color.";
    }

    public String getLongDescription() {
        return "This displays messages to the console for events and errors.  If color is enabled, then it displays them in ANSI color codes, which work on Linux, but not on Windows XP, it seems.  I read somewhere about enabling ANSI.sys on Windows to get it working, and if anybody manages that, please let me know.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        String string = System.getProperty("os.name");
        if (string.toLowerCase().matches(".*Windows.*")) {
            properties.setProperty("colors", "false");
        } else {
            properties.setProperty("colors", "true");
        }
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("colors", "Display ANSI colors on the console (NOT recommended for Windows).");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("colors")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public boolean isRequiredPlugin() {
        return true;
    }
}

