/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BnetEventProcess;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.RawEventCallback;
import com.javaop.util.BnetEvent;
import com.javaop.util.gui.JTextFieldNumeric;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements RawEventCallback {
    private PublicExposedFunctions out;
    private Hashtable<String, Vector<BnetEvent>> queuedMessages = new Hashtable();
    private Hashtable<String, Callback> timers = new Hashtable();
    private Timer timer = new Timer();

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 1, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 2, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 3, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 4, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 5, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 6, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 7, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 9, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 10, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 13, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 14, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 18, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 19, null);
        pluginCallbackRegister.registerRawEventPlugin((RawEventCallback)this, 23, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "BnetEventProcess";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "A simple event parser.";
    }

    public String getLongDescription() {
        return "A very simple event parser which just translates the incoming events (EID_JOIN, forinstance) into the appropriate events that can be understood by the display plugins. The reason this is separate is so that a filter can be put in the middle that will hide floodbots and such. If you're using a different event processor, DON'T use this one too. Otherwise, you'll end up seeing events happening twice.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Ignore floodbots", "true");
        properties.setProperty("Time to ignore", "400");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Ignore floodbots", "If a user joins and leaves really fast, events from him won't be processed");
        properties.setProperty("Time to ignore", "The time, in milliseconds, before the user's events are processed");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("Ignore floodbots")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("Time to ignore")) {
            return new JTextFieldNumeric(string2);
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public BnetEvent eventOccurring(BnetEvent bnetEvent, Object object) throws IOException, PluginException {
        return bnetEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccurred(BnetEvent bnetEvent, Object object) throws IOException, PluginException {
        boolean bl = this.out.getLocalSettingDefault(this.getName(), "Ignore floodbots", "true").equalsIgnoreCase("true");
        if (!bl) {
            this.processEvent(bnetEvent);
        } else {
            int n = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "Time to ignore", "200"));
            PluginMain pluginMain = this;
            synchronized (pluginMain) {
                int n2 = bnetEvent.getCode();
                if (n2 == 2) {
                    Vector<BnetEvent> vector = new Vector<BnetEvent>();
                    vector.add(bnetEvent);
                    this.queuedMessages.put(bnetEvent.getUsername(), vector);
                    Callback callback = new Callback(bnetEvent.getUsername());
                    this.timers.put(bnetEvent.getUsername(), callback);
                    this.timer.schedule((TimerTask)callback, n);
                } else if (n2 == 3) {
                    if (!this.cancelCallback(bnetEvent.getUsername())) {
                        this.processEvent(bnetEvent);
                    }
                } else {
                    Vector<BnetEvent> vector = this.queuedMessages.get(bnetEvent.getUsername());
                    if (vector == null) {
                        this.processEvent(bnetEvent);
                    } else {
                        vector.add(bnetEvent);
                    }
                }
            }
        }
    }

    private boolean cancelCallback(String string) {
        this.queuedMessages.remove(string);
        Callback callback = this.timers.remove(string);
        if (callback != null) {
            callback.cancel();
        }
        return callback != null;
    }

    private void processEvent(BnetEvent bnetEvent) throws IOException, PluginException {
        String string = bnetEvent.getUsername();
        String string2 = bnetEvent.getMessage();
        int n = bnetEvent.getPing();
        int n2 = bnetEvent.getFlags();
        switch (bnetEvent.getCode()) {
            case 5: {
                this.out.talk(string, string2, n, n2);
                break;
            }
            case 23: {
                this.out.emote(string, string2, n, n2);
                break;
            }
            case 4: {
                this.out.whisperFrom(string, string2, n, n2);
                break;
            }
            case 10: {
                this.out.whisperTo(string, string2, n, n2);
                break;
            }
            case 1: {
                this.out.userShow(string, string2, n, n2);
                break;
            }
            case 2: {
                this.out.userJoin(string, string2, n, n2);
                break;
            }
            case 3: {
                this.out.userLeave(string, string2, n, n2);
                break;
            }
            case 9: {
                this.out.userFlags(string, string2, n, n2);
                break;
            }
            case 13: 
            case 14: 
            case 19: {
                this.out.error(string, string2, n, n2);
                break;
            }
            case 18: {
                this.out.info(string, string2, n, n2);
                break;
            }
            case 6: {
                this.out.broadcast(string, string2, n, n2);
                break;
            }
            case 7: {
                this.out.channel(string, string2, n, n2);
            }
        }
    }

    private class Callback
    extends TimerTask {
        private final String username;

        public Callback(String string) {
            this.username = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Callback callback = this;
            synchronized (callback) {
                try {
                    Vector vector = (Vector)PluginMain.this.queuedMessages.get(this.username);
                    if (vector == null) {
                        return;
                    }
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        PluginMain.this.processEvent((BnetEvent)enumeration.nextElement());
                    }
                    PluginMain.this.cancelCallback(this.username);
                }
                catch (Exception exception) {
                    PluginMain.this.out.systemMessage(4, "Error processing event: " + exception);
                }
            }
        }
    }
}

