/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BasicCommands;

import com.javaop.BasicCommands.TimeReader;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.User;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback,
EventCallback {
    private PublicExposedFunctions out;
    private static long loaded = 0L;
    private String lastWhisper = "<n/a>";

    public void load(StaticExposedFunctions staticExposedFunctions) {
        loaded = System.currentTimeMillis();
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "join", 1, false, "J", "<channel>", "Joins the specified channel", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "rejoin", 0, false, "J", "", "Rejoins the current channel", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "uptime", 0, false, "ALN", "", "Gives the time the bot's been online for", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "ping", 1, false, "AN", "<user>", "Pings the specified user", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "where", 0, false, "ALN", "", "Tells the user where the bot is", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "say", 1, false, "T", "<text>", "Says the specified text out loud", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "lastwhisper", 0, false, "N", "", "Shows the last user to give a command", null);
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "BasicCommands";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Basic commands";
    }

    public String getLongDescription() {
        return "A collection of basic commands that most bots have.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Instant joins", "true");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Instant joins", "If this is set, joins will happen instantly without waiting for other events to occur.");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return new JCheckBox("", string2.equalsIgnoreCase("true"));
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public boolean isRequiredPlugin() {
        return true;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("join")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("join requires a parameter", string, string2);
            }
            if (this.out.getLocalSettingDefault(this.getName(), "Instant joins", "true").equalsIgnoreCase("true")) {
                BnetPacket bnetPacket = new BnetPacket(12);
                bnetPacket.addDWord(2);
                bnetPacket.addNTString(stringArray[0]);
                this.out.sendPacket((Buffer)bnetPacket);
            } else {
                this.out.sendText("/join " + stringArray[0]);
            }
        } else if (string2.equalsIgnoreCase("rejoin")) {
            if (this.out.getLocalSettingDefault(this.getName(), "Instant joins", "true").equalsIgnoreCase("true")) {
                BnetPacket bnetPacket = new BnetPacket(16);
                this.out.sendPacket((Buffer)bnetPacket);
                BnetPacket bnetPacket2 = new BnetPacket(12);
                bnetPacket2.addDWord(2);
                bnetPacket2.addNTString(this.out.channelGetName());
                this.out.sendPacket((Buffer)bnetPacket2);
            } else {
                String string3 = this.out.channelGetName();
                this.out.sendText("/join some random JavaOp-channel!");
                this.out.sendText("/join " + string3);
            }
        } else if (string2.equalsIgnoreCase("uptime")) {
            this.out.sendTextUserPriority(string, "This bot has been up for " + TimeReader.timeToString(System.currentTimeMillis() - loaded), n, -50);
        } else if (string2.equalsIgnoreCase("ping")) {
            User user;
            if (stringArray.length == 0) {
                stringArray = new String[]{string};
            }
            if ((user = this.out.channelGetUser(stringArray[0])) == null) {
                if (string != null) {
                    this.out.sendTextPriority("/w " + stringArray[0] + " [ping]" + string, -50);
                } else {
                    this.out.sendText("/w " + stringArray[0] + " [ping]" + "<local>");
                }
            } else {
                this.out.sendTextUserPriority(string, stringArray[0] + "'s ping is " + user.getPing() + "ms", n, -50);
            }
        } else if (string2.equalsIgnoreCase("where")) {
            this.out.sendTextUser(string, "I am in channel: " + this.out.channelGetName(), -50);
        } else if (string2.equalsIgnoreCase("say")) {
            if (stringArray.length == 0 || stringArray[0].length() < 1) {
                throw new CommandUsedImproperly("Say requires a parameter", string, string2);
            }
            if (stringArray[0].charAt(0) == '/' && !this.out.dbHasAny(string, "N", true)) {
                stringArray[0] = " " + stringArray[0];
            }
            if (this.out.dbHasAny(string, "M", true)) {
                this.out.sendTextPriority(stringArray[0], 101);
            } else {
                this.out.sendTextPriority(stringArray[0], -50);
            }
        } else if (string2.equalsIgnoreCase("lastwhisper")) {
            this.out.sendTextUserPriority(string, "Last whisper was: " + this.lastWhisper, 0, -50);
        } else {
            this.out.sendTextUser(string, "There is an error in BasicCommands -- missing a command -- please inform iago", n);
        }
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.lastWhisper = "<" + string + "> " + string2;
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (string2.matches("\\[ping\\].*")) {
            String string3 = string2.replaceAll("\\[ping\\]", "");
            if (string.equalsIgnoreCase("<local>")) {
                this.out.sendTextUserPriority(string3, string + "'s ping is " + n + "ms", 3, -50);
            } else {
                this.out.sendTextUserPriority(string3, string + "'s ping is " + n + "ms", 0, -50);
            }
        }
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
    }
}

