/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.UserManagement;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.PersistantMap;
import com.javaop.util.RelativeFile;
import com.javaop.util.Uniq;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback {
    private PublicExposedFunctions out;
    private static StaticExposedFunctions funcs;
    private PersistantMap mymap;

    public void load(StaticExposedFunctions staticExposedFunctions) {
        funcs = staticExposedFunctions;
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        this.mymap = new PersistantMap((File)new RelativeFile(publicExposedFunctions.getName() + ".level"), "This is the file that defines text flags.");
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "whoami", 0, false, "AGNL", "", "Shows you all the flags you have", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "setuser", 0, false, "AGN", "<userlist> <flags>", "Adds or removes flags from a user.  The flag list is a set of +/- and flags, like +ABC-D+E-F", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "deluser", 0, false, "AGN", "<userlist>", "Deletes a user from the database", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "find", 0, false, "AGN", "<userlist>", "Finds the flags for the requested user", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "findattr", 1, false, "AGN", "<flag>", "Lists all users with the specified flag", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "whatcanichange", 0, false, "AGNL", "", "Tells you which flags you're allowed to modify", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "setaccesslevel", 2, false, "A", "[access level, flags]", "Adds a new access level with flags.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "useaccesslevel", 2, false, "A", "[user, access level]", "Sets a user to a access level.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "deleteaccesslevel", 1, false, "A", "[access level]", "Deletes an access level. All users in this access level will remain.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "listaccesslevels", 0, false, "A", "", "Gives a list of all access levels.", null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "UserManagement";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago, Ryan Marcus";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Commands for managing users";
    }

    public String getLongDescription() {
        return "This has the commands for adding, finding, and removing users from the user database.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("A can change", "BFLS");
        properties.setProperty("G can change", "BFJLST");
        properties.setProperty("N can change", "ABCDEFGHIJKLNOPQRSTVWXYZ");
        properties.setProperty("P can be modified by", "MN");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("A can change", "This is the lowest flag for members, they can typically change only low level flags.");
        properties.setProperty("G can change", "I put this in as a mid-range access modifier.  Typically, it'll be more powerful than A, but less than N.");
        properties.setProperty("N can change", "This is typically used for a local master (ie, master of this bot).  Can normally change almost everything.");
        properties.setProperty("P can be modified by", "Somebody with the \"P\" flag set can't generally be changed unless you're a master.");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("all flags", "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("all flags", "These are ALL flags that the bot recognizes.");
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("whoami")) {
            this.out.sendTextUserPriority(string, this.out.dbGetFlags(string), n, -50);
        } else if (string2.equalsIgnoreCase("find")) {
            if (stringArray.length < 1) {
                throw new CommandUsedImproperly("Find requires at least one parameter.", string, string2);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.out.sendTextUserPriority(string, stringArray[i] + ": " + this.out.dbGetFlags(stringArray[i]), n, -50);
            }
        } else if (string2.equalsIgnoreCase("deluser")) {
            if (stringArray.length < 1) {
                throw new CommandUsedImproperly("Deluser requires at least one parameter", string, string2);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!this.out.dbUserExists(string3)) {
                    this.out.sendTextUser(string, "Sorry, user \"" + string3 + "\" not found in the database.", n);
                    continue;
                }
                this.changeAndNotify(string, string3, funcs.getGlobalSettingDefault(this.getName(), "all flags", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "", n);
            }
        } else if (string2.equalsIgnoreCase("setuser")) {
            int n2;
            if (stringArray.length < 2) {
                throw new CommandUsedImproperly("Setuser requires at least two parameters", string, string2);
            }
            String string4 = stringArray[stringArray.length - 1];
            String string5 = "";
            String string6 = "";
            boolean bl = true;
            for (n2 = 0; n2 < string4.length(); ++n2) {
                char c = string4.charAt(n2);
                if (c == '+') {
                    bl = true;
                    continue;
                }
                if (c == '-') {
                    bl = false;
                    continue;
                }
                if (bl) {
                    string5 = string5 + c;
                    continue;
                }
                string6 = string6 + c;
            }
            this.out.systemMessage(1, "Flags to add: " + string5);
            this.out.systemMessage(1, "Flags to remove: " + string6);
            for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
                this.changeAndNotify(string, stringArray[n2], string6, string5, n);
            }
        } else if (string2.equalsIgnoreCase("whatcanichange")) {
            String string7 = this.getAllowedChanges(string);
            if (string7.length() == 0) {
                string7 = "<nothing>";
            }
            this.out.sendTextUser(string, "You're allowed to change flags " + string7 + ", and can " + (this.out.dbHasAny(string, this.out.getLocalSetting(this.getName(), "P can be modified by"), true) ? "" : "not ") + "modify users with P flag set.", n);
        } else if (string2.equalsIgnoreCase("findattr")) {
            if (stringArray.length != 1 || stringArray[0].length() != 1) {
                throw new CommandUsedImproperly("findattr requires a single character parameter", string, string2);
            }
            String[] stringArray2 = this.out.dbFindAttr(stringArray[0].charAt(0));
            StringBuffer stringBuffer = new StringBuffer("Users with " + stringArray[0] + ": ");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append(stringArray2[i] + " ");
            }
            this.out.sendTextUser(string, stringBuffer.toString(), n);
        } else if (string2.equalsIgnoreCase("setaccesslevel")) {
            if (stringArray.length != 2) {
                throw new CommandUsedImproperly("setaccesslevel requires two parameters.", string, string2);
            }
            this.mymap.set("Definitions", stringArray[0], stringArray[1]);
            this.out.sendTextUser(string, "Access level added: " + stringArray[0] + " => " + stringArray[1], 0);
        } else if (string2.equalsIgnoreCase("useaccesslevel")) {
            if (stringArray.length != 2) {
                throw new CommandUsedImproperly("useaccesslevel requires two parameters.", string, string2);
            }
            String string8 = this.mymap.getNoWrite("Definitions", stringArray[1], "");
            if (string8.equalsIgnoreCase("")) {
                this.out.sendTextUser(string, "That is not an access level!", 0);
            } else {
                this.changeAndNotify(string, stringArray[0], funcs.getGlobalSettingDefault(this.getName(), "all flags", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"), string8, n);
            }
        } else if (string2.equalsIgnoreCase("deleteaccesslevel")) {
            if (stringArray.length != 1) {
                throw new CommandUsedImproperly("deleteaccesslevel requires one parameter.", string, string2);
            }
            this.mymap.remove("Definitions", stringArray[0]);
            this.out.sendTextUser(string, "Access level removed.", n);
        } else if (string2.equalsIgnoreCase("listaccesslevels")) {
            String[] stringArray3 = Uniq.uniq((Enumeration)this.mymap.propertyNames("Definitions"));
            String string9 = "";
            for (int i = 0; i < stringArray3.length; ++i) {
                string9 = string9 + stringArray3[i];
                if (i >= stringArray3.length - 1) continue;
                string9 = string9 + ",";
            }
            if (string9.equalsIgnoreCase("")) {
                this.out.sendTextUser(string, "There are no access levels.", 0);
            } else {
                this.out.sendTextUser(string, string9, n);
            }
        } else {
            this.out.sendTextUser(string, "Error: There was an unknown command.  Please report a problem with UserManagement plugin.", n);
        }
    }

    private String getAllowedChanges(String string) throws PluginException {
        String string2 = "";
        if (this.out.dbHasAny(string, "", true)) {
            string2 = string2 + this.out.getLocalSettingDefault(this.getName(), "all flags", "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        }
        if (this.out.dbHasAny(string, "A", true)) {
            string2 = string2 + this.out.getLocalSettingDefault(this.getName(), "A can change", "BFLS");
        }
        if (this.out.dbHasAny(string, "G", true)) {
            string2 = string2 + this.out.getLocalSettingDefault(this.getName(), "G can change", "BFLS");
        }
        if (this.out.dbHasAny(string, "N", true)) {
            string2 = string2 + this.out.getLocalSettingDefault(this.getName(), "N can change", "ABCDEFGHIJKLNOPQRSTVWXYZ");
        }
        char[] cArray = string2.toCharArray();
        TreeSet<Character> treeSet = new TreeSet<Character>();
        for (int i = 0; i < cArray.length; ++i) {
            treeSet.add(new Character(cArray[i]));
        }
        string2 = "";
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            string2 = string2 + iterator.next();
        }
        this.out.systemMessage(1, "User " + string + " was allowed to change flags " + string2);
        return string2;
    }

    private void changeAndNotify(String string, String string2, String string3, String string4, int n) throws IOException, PluginException {
        String string5;
        this.out.systemMessage(1, string + " is trying to change " + string2);
        this.out.systemMessage(1, "Removing flags: " + string3);
        this.out.systemMessage(1, "Adding flags: " + string4);
        string4 = string4 == null ? "" : string4.toUpperCase();
        String string6 = string3 = string3 == null ? "" : string3.toUpperCase();
        if (this.out.dbHasAny(string2, "P", true) && !this.out.dbHasAny(string, string5 = this.out.getLocalSettingDefault(this.getName(), "P can be modified by", "MN"), true)) {
            this.out.sendTextUser(string, "Sorry, users with the P flag can only be changed by somebody with " + string5 + ".", n);
            return;
        }
        string5 = this.getAllowedChanges(string);
        string3 = string3.replaceAll("[^" + string5 + "]", "");
        string4 = string4.replaceAll("[^" + string5 + "]", "");
        String string7 = this.out.dbGetRawFlags(string2);
        if (string7.length() > 0) {
            string3 = string3.replaceAll("[^" + string7 + "]", "");
        }
        this.out.systemMessage(1, "Final flags to remove: " + string3);
        this.out.systemMessage(1, "Final flags to add: " + string4);
        if (string3.length() == 0 && string4.length() == 0) {
            this.out.sendTextUser(string, "Sorry, couldn't find any flags that you're allowed to add/remove.", n);
            return;
        }
        String string8 = this.out.dbGetRawFlags(string2);
        this.out.dbAddAndRemove(string2, string4, string3);
        String string9 = this.out.dbGetRawFlags(string2);
        if (string8 == null || string8.length() == 0) {
            string8 = "<none>";
        }
        if (string9 == null || string9.length() == 0) {
            string9 = "<none>";
        }
        this.out.sendTextUser(string, string2 + ": " + string8 + " => " + string9 + (string8.equals(string9) ? " (no change)" : ""), n);
    }
}

