/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Help;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.UserErrorCallback;
import com.javaop.util.Uniq;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback,
UserErrorCallback {
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "helpall", 0, false, "ANL", "[command(s)]", "Gives help on the specified command(s). If no commands are specified, it lists all commands.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "help", 0, false, "ANL", "[command(s)]", "Gives help on the specified command(s). If no commands are specified, it lists all commands that you can use.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "usage", 0, false, "ANL", "[command(s)]", "Gives the usage for the specified command(s).", null);
        pluginCallbackRegister.registerUserErrorPlugin((UserErrorCallback)this, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Help";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Provides help on commands.";
    }

    public String getLongDescription() {
        return "It lets users use the .help command.  If no parameters are specified, it lists the commands that the bot currently understands.  If it is given one or more parameters, it'll give the user the usage and description of the command.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Command not found", "false");
        properties.setProperty("Proper usage", "true");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Command not found", "Whispers a user if they use a command that doesn't exist.  Very annoying.");
        properties.setProperty("Proper usage", "Whispers a user if they use a command incorrectly.  Very handy.");
        return properties;
    }

    public boolean isRequiredPlugin() {
        return true;
    }

    public JComponent getComponent(String string, String string2) {
        return new JCheckBox("", string2.equalsIgnoreCase("true"));
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("helpall") || string2.equalsIgnoreCase("help") || string2.equalsIgnoreCase("usage")) {
            if (stringArray.length == 0) {
                String[] stringArray2 = Uniq.uniq((String[])this.out.getCommandList());
                StringBuffer stringBuffer = new StringBuffer("Commands: ");
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!string2.equalsIgnoreCase("helpall") && !this.out.canUse(string, string2)) continue;
                    stringBuffer.append(stringArray2[i]).append(" ");
                }
                this.out.sendTextUserPriority(string, stringBuffer.toString(), n, -50);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = this.out.getCommandOf(stringArray[i]);
                    if (string3 != null && !string3.equalsIgnoreCase(stringArray[i])) {
                        this.out.sendTextUser(string, stringArray[i] + " is an alias for " + string3, n);
                    }
                    if (string2.equalsIgnoreCase("help")) {
                        this.sendHelp(string, stringArray[i], n);
                    }
                    if (!string2.equalsIgnoreCase("usage")) continue;
                    this.sendUsage(string, stringArray[i], n);
                }
            }
        } else {
            this.out.sendTextUser(string, "There is an error in the \"Help\" plugin.  Please report this to iago.", n);
        }
    }

    public void sendHelp(String string, String string2, int n) throws IOException {
        if (this.out.getCommandHelp(string2) == null) {
            this.out.sendTextUser(string, "Command " + string2 + " not found.", n);
        } else {
            this.out.sendTextUserPriority(string, string2 + " " + this.out.getCommandUsage(string2) + " - " + this.out.getRequiredFlags(string2) + " - " + this.out.getCommandHelp(string2), n, -50);
        }
    }

    public void sendUsage(String string, String string2, int n) throws IOException {
        if (this.out.getCommandUsage(string2) == null) {
            this.out.sendTextUser(string, "Command " + string2 + " not found.", n);
        } else {
            this.out.sendTextUser(string, "Usage: " + string2 + " " + this.out.getCommandUsage(string2), n);
        }
    }

    public void illegalCommandUsed(String string, String string2, String string3, String string4, Object object) {
    }

    public void nonExistantCommandUsed(String string, String string2, Object object) {
        try {
            if (this.out.getLocalSettingDefault(this.getName(), "Command not found", "false").equalsIgnoreCase("true")) {
                this.out.sendTextUserPriority(string, "Command \"" + string2 + "\" not found.", 0, -100);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commandUsedImproperly(String string, String string2, String string3, String string4, Object object) {
        try {
            if (this.out.getCommandUsage(string2) == null) {
                this.out.sendTextUser(string, "Command " + string2 + " not found.", 0);
            } else {
                this.out.sendTextUser(string, string4 + " [Proper usage: " + string2 + " " + this.out.getCommandUsage(string2) + "]", 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

