/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.settings;

import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.util.gui.Gui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserDatabaseWizard
extends JFrame
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private final String allFlags;
    private final PublicExposedFunctions out;
    private final CheckPanel checkPanel;
    private final DefaultListModel model = new DefaultListModel();
    private final JList list = new JList(this.model);
    private final JButton addButton = new JButton("Add...");
    private final JButton removeButton = new JButton("Remove");

    public UserDatabaseWizard(PublicExposedFunctions out) {
        this(out, null);
    }

    public UserDatabaseWizard(PublicExposedFunctions out, String user) {
        super("User database for " + out.getName());
        this.out = out;
        String[] users = out.dbGetAllUsers();
        this.allFlags = out.getLocalSettingDefault("user management", "all flags", "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        int i = users.length - 1;
        while (i >= 0) {
            this.model.addElement(users[i]);
            --i;
        }
        JPanel form = new JPanel();
        form.setLayout(new BorderLayout(5, 5));
        form.setBorder(BorderFactory.createLineBorder(form.getBackground(), 5));
        this.getContentPane().add(form);
        JScrollPane scroller = new JScrollPane(this.list);
        scroller.setPreferredSize(new Dimension(150, 0));
        JLabel l = new JLabel("All changes take effect instantly, so be careful!");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(1, 2));
        southPanel.add(this.addButton);
        southPanel.add(this.removeButton);
        form.add((Component)l, "North");
        form.add((Component)scroller, "West");
        form.add((Component)southPanel, "South");
        this.checkPanel = new CheckPanel(this.allFlags, null);
        form.add((Component)this.checkPanel, "Center");
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.checkPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        scroller.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        if (user != null) {
            this.list.setSelectedValue(user, true);
            if (this.list.getSelectedValue() == null) {
                this.model.addElement(user);
                this.list.setSelectedValue(user, true);
            }
            this.valueChanged(null);
        }
        this.list.addListSelectionListener(this);
        this.setDefaultCloseOperation(2);
        this.pack();
        Gui.center((Window)this);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String selected = (String)this.list.getSelectedValue();
        if (selected == null) {
            this.checkPanel.clear();
        } else {
            this.checkPanel.set(this.out.dbGetRawFlags(selected));
            this.checkPanel.setActiveUser(selected);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            String user = JOptionPane.showInputDialog(null, (Object)"Name or pattern for the user?");
            if (user != null) {
                this.model.addElement(user);
            }
        } else if (e.getSource() == this.removeButton) {
            String user = (String)this.list.getSelectedValue();
            int index = this.list.getSelectedIndex();
            if (index >= 0) {
                this.model.remove(index);
                if (index < this.model.size()) {
                    this.list.setSelectedIndex(index);
                }
            }
            this.out.dbDeleteUser(user);
        }
    }

    class CheckPanel
    extends JPanel
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private final JCheckBox[] checkBoxes;
        private final int COLS = 3;
        private final String allFlags;
        private String user = null;

        public CheckPanel(String allFlags, String user) {
            this.allFlags = allFlags;
            this.user = user;
            this.checkBoxes = new JCheckBox[allFlags.length()];
            this.setLayout(new GridLayout(0, 3));
            int oneColSize = allFlags.length() / 3 + 1;
            int i = 0;
            while (i < oneColSize) {
                int j = 0;
                while (j < 3) {
                    int thisLocation = i + j * oneColSize;
                    if (thisLocation >= this.checkBoxes.length) {
                        this.add(new JLabel());
                    } else {
                        this.checkBoxes[thisLocation] = new JCheckBox("" + allFlags.charAt(thisLocation));
                        this.add(this.checkBoxes[thisLocation]);
                        this.checkBoxes[thisLocation].addChangeListener(this);
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void setActiveUser(String user) {
            this.user = user;
        }

        private void setCheckbox(JCheckBox box, boolean state) {
            box.removeChangeListener(this);
            box.setSelected(state);
            box.addChangeListener(this);
        }

        private void clear() {
            int i = 0;
            while (i < this.checkBoxes.length) {
                this.setCheckbox(this.checkBoxes[i], false);
                ++i;
            }
        }

        private void set(String flags) {
            this.clear();
            int i = 0;
            while (i < flags.length()) {
                int flagIndex = this.allFlags.indexOf(flags.charAt(i));
                if (flagIndex >= 0 && flagIndex < this.checkBoxes.length && flagIndex >= 0 && flagIndex < this.checkBoxes.length) {
                    this.setCheckbox(this.checkBoxes[flagIndex], true);
                }
                ++i;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.user != null) {
                String flags = "";
                int i = 0;
                while (i < this.checkBoxes.length) {
                    if (this.checkBoxes[i].isSelected()) {
                        flags = String.valueOf(flags) + this.allFlags.charAt(i);
                    }
                    ++i;
                }
                UserDatabaseWizard.this.out.dbDeleteUser(this.user);
                UserDatabaseWizard.this.out.dbAddFlags(this.user, flags);
            }
        }
    }
}

