/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.settings;

import com.javaop.SwingGui.settings.PluginPanel;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.Uniq;
import com.javaop.util.gui.Gui;
import com.javaop.util.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class SettingWizard
extends JFrame
implements ListSelectionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private JPanel form;
    private JTable list;
    private PublicExposedFunctions out;
    private PreferencesPanel rightPreferences;
    private String currentPlugin = "Default";
    private SelectPlugin[] pluginList;
    private final JPanel right = new JPanel();

    public SettingWizard(PublicExposedFunctions out) {
        super("Configuring " + out.getName());
        this.out = out;
        this.form = new JPanel();
        this.getContentPane().add(this.form);
        this.setSize(700, 500);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        Gui.center((Window)this);
        this.form.setLayout(new BorderLayout(3, 3));
        GenericPluginInterface[] allPlugins = out.getStaticExposedFunctionsHandle().pluginGetAll(true);
        this.pluginList = new SelectPlugin[allPlugins.length];
        int i = 0;
        while (i < allPlugins.length) {
            this.pluginList[i] = new SelectPlugin(allPlugins[i], out.pluginIsActive(allPlugins[i].getName()));
            ++i;
        }
        this.list = new PluginTable(this.pluginList);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(195, -1));
        this.getContentPane().add((Component)listScroller, "West");
        this.list.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.list.getSelectionModel().addListSelectionListener(this);
        this.list.getSelectionModel().setSelectionInterval(0, 0);
        this.getContentPane().add((Component)this.right, "Center");
        this.right.setLayout(new BorderLayout(10, 0));
        this.right.add((Component)new JLabel("Please select a plugin to configure"), "Center");
        this.valueChanged(null);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.saveRight();
        String thisPlugin = (String)this.list.getModel().getValueAt(this.list.getSelectedRow(), 1);
        Properties defaultSettings = this.out.getStaticExposedFunctionsHandle().pluginGetDefaultSettings(thisPlugin);
        Properties descriptions = this.out.getStaticExposedFunctionsHandle().pluginGetDescriptions(thisPlugin);
        Properties settings = this.out.getLocalSettingSection(thisPlugin);
        Hashtable components = this.out.getStaticExposedFunctionsHandle().pluginGetComponents(thisPlugin, settings);
        this.currentPlugin = thisPlugin;
        this.right.removeAll();
        this.right.add((Component)new PluginPanel(thisPlugin, this.out.getStaticExposedFunctionsHandle()), "North");
        this.rightPreferences = new PreferencesPanel(settings, defaultSettings, descriptions, components);
        JScrollPane scroller = new JScrollPane((Component)this.rightPreferences);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.getVerticalScrollBar().setUnitIncrement(10);
        scroller.getVerticalScrollBar().setValueIsAdjusting(true);
        scroller.getVerticalScrollBar().setValue(0);
        scroller.getVerticalScrollBar().setValueIsAdjusting(false);
        this.right.add((Component)scroller, "Center");
        this.right.validate();
        this.form.validate();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            this.saveRight();
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(null, "Sorry, was unable to save.  See console output for more information: " + exc);
            exc.printStackTrace();
        }
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void saveRight() {
        if (this.rightPreferences == null || !this.rightPreferences.hasChanged()) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Save the settings for this plugin?", "Save?", 0) == 1) {
            return;
        }
        Properties newPref = this.rightPreferences.getValues();
        String[] keys = Uniq.uniq(newPref.keys());
        int i = 0;
        while (i < keys.length) {
            this.out.putLocalSetting(this.currentPlugin, keys[i], newPref.getProperty(keys[i]));
            ++i;
        }
    }

    private class BooleanTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private final SelectPlugin[] plugins;

        public BooleanTableModel(SelectPlugin[] plugins) {
            super(plugins.length, 2);
            this.plugins = plugins;
        }

        public Class getColumnClass(int col) {
            return col == 0 ? Boolean.class : super.getColumnClass(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return new Boolean(this.plugins[row].getCheck().isSelected());
            }
            return this.plugins[row].toString();
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            this.plugins[row].toggleSelected();
        }
    }

    private class PluginTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public PluginTable(SelectPlugin[] plugins) {
            super(new BooleanTableModel(plugins));
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(0).setWidth(20);
            this.getColumnModel().getColumn(1).setPreferredWidth(175);
            this.getColumnModel().getColumn(1).setWidth(175);
            this.setCellSelectionEnabled(false);
            this.setShowGrid(false);
            this.setTableHeader(null);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.validate();
        }
    }

    private class SelectPlugin {
        private final GenericPluginInterface plugin;
        private JCheckBox check;

        public SelectPlugin(GenericPluginInterface plugin, boolean selected) {
            this.plugin = plugin;
            this.check = new JCheckBox(plugin.getName(), selected);
        }

        public void toggleSelected() {
            SettingWizard.this.out.pluginToggleActive(this.plugin.getName());
            this.check.setSelected(SettingWizard.this.out.pluginIsActive(this.plugin.getName()));
        }

        public void setSelected(boolean selected) {
            this.check.setSelected(selected);
        }

        public boolean getSelected() {
            return this.check.isSelected();
        }

        public JCheckBox getCheck() {
            return this.check;
        }

        public GenericPluginInterface getPlugin() {
            return this.plugin;
        }

        public String toString() {
            return this.plugin.getName();
        }
    }
}

