/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.settings;

import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.util.Uniq;
import com.javaop.util.gui.Gui;
import com.javaop.util.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GlobalSettingWizard
extends JFrame
implements ListSelectionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private JPanel form;
    private JList list;
    private StaticExposedFunctions funcs;
    private PreferencesPanel rightPreferences;
    private JScrollPane oldRight = null;
    private String currentPlugin = "Default";

    public GlobalSettingWizard(StaticExposedFunctions funcs) {
        super("Configuring static settings");
        this.funcs = funcs;
        this.form = new JPanel();
        this.getContentPane().add(this.form);
        this.form.setLayout(new BorderLayout(3, 3));
        String[] pluginNames = funcs.pluginGetNames();
        Vector<String> usefulPlugins = new Vector<String>();
        int i = 0;
        while (i < pluginNames.length) {
            if (funcs.getGlobalKeys(pluginNames[i]).length != 0) {
                usefulPlugins.add(pluginNames[i]);
                System.out.println("Useful: " + pluginNames[i]);
            } else {
                System.out.println("Not useful: " + pluginNames[i]);
            }
            ++i;
        }
        this.list = new JList(usefulPlugins);
        this.getContentPane().add((Component)new JScrollPane(this.list), "West");
        this.list.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.list.getSelectionModel().addListSelectionListener(this);
        this.list.getSelectionModel().setSelectionInterval(0, 0);
        this.list.setPreferredSize(new Dimension(200, 0));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setSize(700, 500);
        Gui.center((Window)this);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.saveRight();
        String thisPlugin = (String)this.list.getSelectedValue();
        String[] settingNames = this.funcs.getGlobalKeys(thisPlugin);
        Properties defaultSettings = this.funcs.pluginGetGlobalDefaultSettings(thisPlugin);
        Properties descriptions = this.funcs.pluginGetGlobalDescriptions(thisPlugin);
        Properties settings = new Properties();
        int i = 0;
        while (i < settingNames.length) {
            settings.setProperty(settingNames[i], this.funcs.getGlobalSettingDefault(thisPlugin, settingNames[i], defaultSettings.getProperty(settingNames[i])));
            ++i;
        }
        Hashtable components = this.funcs.pluginGetGlobalComponents(thisPlugin, settings);
        if (this.oldRight != null) {
            this.form.remove(this.oldRight);
        }
        this.currentPlugin = thisPlugin;
        this.rightPreferences = new PreferencesPanel(settings, defaultSettings, descriptions, components);
        this.oldRight = new JScrollPane((Component)this.rightPreferences);
        this.form.add((Component)this.oldRight, "Center");
        this.oldRight.setHorizontalScrollBarPolicy(31);
        this.oldRight.setVerticalScrollBarPolicy(22);
        this.form.validate();
        this.oldRight.getVerticalScrollBar().setUnitIncrement(10);
        this.oldRight.getVerticalScrollBar().getModel().setValue(this.oldRight.getVerticalScrollBar().getModel().getMinimum());
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            this.saveRight();
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(null, "Sorry, was unable to save.  See console output for more information: " + exc);
            exc.printStackTrace();
        }
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void saveRight() {
        if (this.rightPreferences == null || !this.rightPreferences.hasChanged()) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Save the settings for this plugin?", "Save?", 0) == 1) {
            return;
        }
        Properties newPref = this.rightPreferences.getValues();
        String[] keys = Uniq.uniq(newPref.keys());
        int i = 0;
        while (i < keys.length) {
            this.funcs.setGlobalSetting(this.currentPlugin, keys[i], newPref.getProperty(keys[i]));
            ++i;
        }
    }
}

