/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class TextFieldHistory
extends JTextField
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private final String[] history;
    private final int size;
    int position = 0;

    public TextFieldHistory(int historySize) {
        this.size = historySize;
        this.history = new String[this.size];
        this.addKeyListener(this);
    }

    public TextFieldHistory(int historySize, String text) {
        super(text);
        this.size = historySize;
        this.history = new String[this.size];
        this.addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.history[this.position] = this.getText();
            --this.position;
            this.position = (this.position + this.size) % this.size;
            super.setText(this.history[this.position]);
            this.highlight();
        } else if (e.getKeyCode() == 40) {
            this.history[this.position] = this.getText();
            ++this.position;
            this.position %= this.size;
            super.setText(this.history[this.position]);
            this.highlight();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void highlight() {
        this.selectAll();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void setText(String str) {
        this.history[this.position] = this.getText();
        ++this.position;
        this.position %= this.size;
        super.setText(str);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new GridLayout(2, 1));
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 300);
        frame.setVisible(true);
        JButton button = new JButton("*click*");
        TextFieldHistory test = new TextFieldHistory(500);
        frame.getContentPane().add(test);
        frame.getContentPane().add(button);
        frame.pack();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFieldHistory.this.setText("");
            }
        });
    }
}

