/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.gui;

import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.gui.Gui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ProfileDisplay
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private final PublicExposedFunctions out;
    private final String name;
    private final String sex;
    private final String age;
    private final String location;
    private final String description;
    private final JTextField nameField;
    private final JTextField sexField;
    private final JTextField ageField;
    private final JTextField locationField;
    private final JTextArea descriptionField;

    public ProfileDisplay(PublicExposedFunctions out, String name, String sex, String age, String location, String description) {
        super("Profile for " + name);
        this.out = out;
        this.name = name;
        this.sex = sex;
        this.age = age;
        this.location = location;
        this.description = description;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout(5, 5));
        this.nameField = new JTextField(name);
        this.sexField = new JTextField(sex);
        this.ageField = new JTextField(age);
        this.locationField = new JTextField(location);
        this.descriptionField = new JTextArea(description);
        this.nameField.setEditable(false);
        if (!((String)out.getLocalVariable((Object)"username")).equalsIgnoreCase(name)) {
            this.sexField.setEditable(false);
            this.ageField.setEditable(false);
            this.locationField.setEditable(false);
            this.descriptionField.setEditable(false);
        }
        ValuePanel namePanel = new ValuePanel("Name", this.nameField, "West");
        ValuePanel sexPanel = new ValuePanel("Sex", this.sexField, "West");
        ValuePanel agePanel = new ValuePanel("Age", this.ageField, "West");
        ValuePanel locationPanel = new ValuePanel("Location", this.locationField, "North");
        ValuePanel descriptionPanel = new ValuePanel("Description", new JScrollPane(this.descriptionField), "North");
        JPanel topTop = new JPanel();
        topTop.setLayout(new GridLayout(1, 3, 5, 5));
        topTop.add(namePanel);
        topTop.add(sexPanel);
        topTop.add(agePanel);
        topPanel.add((Component)topTop, "North");
        topPanel.add((Component)locationPanel, "South");
        mainPanel.add((Component)descriptionPanel, "Center");
        mainPanel.add((Component)topPanel, "North");
        this.getContentPane().add(mainPanel);
        this.setSize(330, 210);
        this.addWindowListener(this);
        Gui.center((Window)this);
        this.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!(!((String)this.out.getLocalVariable((Object)"username")).equalsIgnoreCase(this.name) || this.sex.equals(this.sexField.getText()) && this.age.equals(this.ageField.getText()) && this.location.equals(this.locationField.getText()) && this.description.equals(this.descriptionField.getText()) || JOptionPane.showConfirmDialog(this, "Save new profile?", "Save?", 0) != 0)) {
            BnetPacket write = new BnetPacket(39);
            write.addDWord(1);
            write.addDWord(4);
            write.addNTString(this.name);
            write.addNTString("profile\\sex");
            write.addNTString("profile\\age");
            write.addNTString("profile\\location");
            write.addNTString("profile\\description");
            write.addNTString(this.sexField.getText());
            write.addNTString(this.ageField.getText());
            write.addNTString(this.locationField.getText());
            write.addNTString(this.descriptionField.getText());
            try {
                this.out.sendPacket((Buffer)write);
            }
            catch (IOException err) {
                JOptionPane.showMessageDialog(this, "Error writing user data: " + err);
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private class ValuePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JComponent component;

        public ValuePanel(String name, JComponent component) {
            this(name, component, "West");
        }

        public ValuePanel(String name, JComponent component, String nameLocation) {
            this.component = component;
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(name), nameLocation);
            this.add((Component)component, "Center");
        }

        public JComponent getComponent() {
            return this.component;
        }
    }
}

