/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.gui;

import com.javaop.SwingGui.util.GameIcons;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

class Model
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Vector users = new Vector();
    private boolean opsOnTop;

    public Model(boolean opsOnTop) {
        this.opsOnTop = opsOnTop;
    }

    public Row removeUser(String name) {
        int oldRowIndex = this.users.indexOf(new Row(name, null, null, 0, 0));
        if (oldRowIndex < 0) {
            return null;
        }
        Row oldRow = (Row)this.users.get(oldRowIndex);
        this.users.remove(oldRow);
        this.fireTableDataChanged();
        return oldRow;
    }

    public Row findUser(String name) {
        int index = this.users.indexOf(new Row(name, null, null, 0, 0));
        if (index < 0) {
            return null;
        }
        return (Row)this.users.get(index);
    }

    public void addUser(String name, String client, String clan, int ping, int flags) {
        Row row;
        if (name == null) {
            return;
        }
        if (client == null) {
            client = "CHAT";
        }
        if (clan == null) {
            clan = "";
        }
        if ((row = this.findUser(name)) == null) {
            row = new Row(name, client, clan, ping, flags);
            if (this.opsOnTop && (flags & 2) > 0 || (flags & 1) > 0 || (flags & 8) > 0) {
                this.users.add(0, row);
            } else {
                this.users.add(row);
            }
        } else {
            if (name.length() > 0) {
                row.setName(name);
            }
            if (client.length() > 0) {
                row.setClient(client);
            }
            row.setPing(ping);
            row.setFlags(flags);
            if (this.opsOnTop && (flags & 2) > 0 || (flags & 1) > 0 || (flags & 8) > 0) {
                this.users.remove(row);
                this.users.add(0, row);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.users.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.users.size()) {
            return null;
        }
        Row rowData = (Row)this.users.get(row);
        switch (column) {
            case 0: {
                return rowData.getGameIcon();
            }
            case 1: {
                return rowData.getName();
            }
            case 2: {
                return rowData.getPingIcon();
            }
            case 3: {
                return rowData.getClan();
            }
        }
        return "Error";
    }

    public String getTooltip(int row, int column) {
        if (row < 0 || row > this.users.size()) {
            return null;
        }
        Row rowData = (Row)this.users.get(row);
        switch (column) {
            case 0: {
                return "Client: " + rowData.getClient();
            }
            case 1: {
                return "Username: " + rowData.getName();
            }
            case 2: {
                return "Ping: " + rowData.getPing() + "ms";
            }
            case 3: {
                return "Clan: " + rowData.getClan();
            }
        }
        return "Error";
    }

    public Class getColumnClass(int i) {
        switch (i) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return ImageIcon.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public void clear() {
        this.users.clear();
        this.fireTableDataChanged();
    }

    private class Row {
        private String name;
        private String client;
        private String clan;
        private int ping;
        private int flags;

        public Row(String name, String client, String clan, int ping, int flags) {
            this.name = name;
            this.client = client;
            this.clan = clan;
            this.ping = ping;
            this.flags = flags;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public String getClient() {
            return this.client;
        }

        public void setClan(String clan) {
            this.clan = clan;
        }

        public String getClan() {
            return this.clan;
        }

        public void setPing(int ping) {
            this.ping = ping;
        }

        public int getPing() {
            return this.ping;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public int getFlags() {
            return this.flags;
        }

        public ImageIcon getGameIcon() {
            if ((this.flags & 0x20) > 0) {
                return GameIcons.getIcon("SQUELCHED");
            }
            if ((this.flags & 8) > 0) {
                return GameIcons.getIcon("SYSOP");
            }
            if ((this.flags & 1) > 0) {
                return GameIcons.getIcon("BLIZZARD");
            }
            if ((this.flags & 4) > 0) {
                return GameIcons.getIcon("SPEAKER");
            }
            if ((this.flags & 2) > 0) {
                return GameIcons.getIcon("OPS");
            }
            if (this.client != null && !this.client.isEmpty()) {
                return GameIcons.getIcon(this.client);
            }
            return null;
        }

        public ImageIcon getPingIcon() {
            if ((this.flags & 0x10) > 0) {
                return GameIcons.getIcon("DISCONNECTED");
            }
            if (this.ping == 0) {
                return null;
            }
            if (this.ping < 200) {
                return GameIcons.getIcon("1g");
            }
            if (this.ping < 300) {
                return GameIcons.getIcon("2g");
            }
            if (this.ping < 400) {
                return GameIcons.getIcon("3y");
            }
            if (this.ping < 500) {
                return GameIcons.getIcon("4y");
            }
            if (this.ping < 600) {
                return GameIcons.getIcon("5r");
            }
            return GameIcons.getIcon("6r");
        }

        public boolean equals(Object o) {
            if (o instanceof Row && ((Row)o).getName().equalsIgnoreCase(this.getName())) {
                return true;
            }
            return o instanceof String && ((String)o).equalsIgnoreCase(this.getName());
        }

        public String toString() {
            return this.name;
        }
    }
}

