/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LoadWebsite
extends Thread
implements ActionListener,
HyperlinkListener {
    private final String site;
    private JFrame window;
    private JEditorPane editor;

    public LoadWebsite(String site) {
        this.site = site;
        this.setName("Load-Website");
        this.start();
    }

    @Override
    public void run() {
        try {
            this.window = new JFrame(this.site);
            JPanel form = new JPanel();
            this.window.getContentPane().add(form);
            form.setLayout(new BorderLayout());
            JButton close = new JButton("Close");
            close.addActionListener(this);
            this.editor = new JEditorPane(this.site);
            this.editor.setEditable(false);
            this.editor.addHyperlinkListener(this);
            form.add((Component)new JScrollPane(this.editor), "Center");
            form.add((Component)close, "South");
            this.window.setDefaultCloseOperation(2);
            this.window.setSize(450, 450);
            this.window.setVisible(true);
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(this.window, "Error loading site: " + exc);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.window.dispose();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.editor.setPage(e.getURL());
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this.window, "Error loading site: " + exc);
            }
        }
    }
}

