/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.gui;

import com.javaop.util.ColorConstants;
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ColorTextArea
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private final Color foreground;
    private final int maxChars;
    private final int cutTo;
    private final boolean holdAtBottom;
    private int styleNum = 0;
    private final StringBuffer fullText = new StringBuffer();

    public ColorTextArea(int maxChars, int cutTo, boolean holdAtBottom) {
        this(Color.BLACK, Color.WHITE, maxChars, cutTo, holdAtBottom);
    }

    public ColorTextArea(Color background, Color foreground, int maxChars, int cutTo, boolean holdAtBottom) {
        this.foreground = foreground;
        this.maxChars = maxChars;
        this.cutTo = cutTo;
        this.holdAtBottom = holdAtBottom;
        this.setBackground(background);
        this.setForeground(foreground);
        this.setSelectionColor(Color.LIGHT_GRAY);
    }

    public void addText(String str) {
        this.addText(str, true);
    }

    private synchronized void addText(String str, boolean append) {
        boolean goToEnd;
        str = String.valueOf(ColorConstants.getColor((String)"Timestamp")) + str;
        if (append) {
            this.fullText.append(str);
        }
        int length = this.getText().length();
        boolean bl = goToEnd = this.holdAtBottom || this.getSelectionStart() + 100 > length;
        if (!append) {
            this.setText("");
        }
        StyledDocument document = this.getStyledDocument();
        Style styles = StyleContext.getDefaultStyleContext().getStyle("default");
        String style = "style" + ++this.styleNum;
        try {
            StyleConstants.setForeground(document.addStyle(style, styles), this.foreground);
            String[] colorStrings = str.split("\\\u8000");
            int i = 0;
            while (i < colorStrings.length) {
                if (colorStrings[i].length() >= 6) {
                    int red = Integer.parseInt("" + colorStrings[i].charAt(0) + colorStrings[i].charAt(1), 16);
                    int green = Integer.parseInt("" + colorStrings[i].charAt(2) + colorStrings[i].charAt(3), 16);
                    int blue = Integer.parseInt("" + colorStrings[i].charAt(4) + colorStrings[i].charAt(5), 16);
                    StyleConstants.setForeground(document.addStyle(style, styles), new Color(red, green, blue));
                    document.insertString(document.getLength(), colorStrings[i].substring(6), document.getStyle(style));
                }
                ++i;
            }
            this.chop();
            document.removeStyle(style);
            if (goToEnd) {
                this.setSelectionStart(this.getText().length());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                document.insertString(document.getLength(), "\n", document.getStyle(style));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void chop() {
        if (this.maxChars <= 0) {
            return;
        }
        if (this.cutTo <= 0) {
            return;
        }
        try {
            if (this.fullText.length() > this.maxChars) {
                this.fullText.delete(0, this.fullText.length() - this.cutTo);
                this.addText(this.fullText.toString(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

