/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui.gui;

import com.javaop.SwingGui.gui.Model;
import com.javaop.SwingGui.util.JMultiLineTooltip;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class ChannelList
extends JTable {
    private static final long serialVersionUID = 1L;
    private Model tableModel;

    public ChannelList(boolean opsOnTop) {
        this.tableModel = new Model(opsOnTop);
        this.setModel(this.tableModel);
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
        this.setShowGrid(false);
        this.setTableHeader(null);
        this.setSelectionMode(0);
        this.setAutoResizeMode(4);
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
        TableColumnModel t = this.getColumnModel();
        t.getColumn(0).setPreferredWidth(24);
        t.getColumn(1).setPreferredWidth(120);
        t.getColumn(2).setPreferredWidth(24);
        t.getColumn(3).setPreferredWidth(48);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(String.valueOf(this.getTooltip(row, column)));
        }
        return c;
    }

    @Override
    public JToolTip createToolTip() {
        return new JMultiLineTooltip();
    }

    public void addUser(String name, String client, String clan, int ping, int flags) {
        this.tableModel.addUser(name, client, clan, ping, flags);
        this.repaint();
    }

    public String getTooltip(int row, int column) {
        return this.tableModel.getTooltip(row, column);
    }

    public void removeUser(String name) {
        this.tableModel.removeUser(name);
    }

    public void clear() {
        this.tableModel.clear();
        this.repaint();
    }

    public int length() {
        return this.tableModel.getRowCount();
    }
}

