/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui;

import com.javaop.SwingGui.settings.UserDatabaseWizard;
import com.javaop.SwingGui.util.MenuIcons;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class JavaOpUserMenu {
    private Vector items = new Vector();
    private final JMenuItem separator = new JMenuItem();
    private final Hashtable<String, ActionListener> actions = new Hashtable();
    private final Hashtable<String, Icon> icons = new Hashtable();
    private final PublicExposedFunctions pubFuncs;

    public JavaOpUserMenu(PublicExposedFunctions pubFuncs) {
        this.pubFuncs = pubFuncs;
    }

    public void addItem(String name, int index, Icon icon, ActionListener callback) {
        if (index >= 0) {
            this.items.add(index, name);
        } else {
            this.items.add(name);
        }
        if (icon != null) {
            this.icons.put(name, icon);
        }
        if (callback != null) {
            this.actions.put(name, callback);
        }
    }

    public void removeItem(String name) {
        this.items.remove(name);
        this.actions.remove(name);
        this.icons.remove(name);
    }

    public JPopupMenu getMenu(String name) {
        return new UserMenuImpl(name);
    }

    public void addSeparator() {
        this.items.add(this.separator);
    }

    private class UserMenuImpl
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final JMenuItem nameItem;
        private final JMenuItem whisper = new JMenuItem("Whisper");
        private final JMenuItem ban = new JMenuItem("Ban");
        private final JMenuItem banMessage = new JMenuItem("Ban (message)...");
        private final JMenuItem kick = new JMenuItem("Kick");
        private final JMenuItem kickMessage = new JMenuItem("Kick (message)...");
        private final JMenuItem squelch = new JMenuItem("Squelch");
        private final JMenuItem unsquelch = new JMenuItem("Unsquelch");
        private final JMenuItem designate = new JMenuItem("Designate");
        private final JMenuItem op = new JMenuItem("Op");
        private final JMenuItem edit = new JMenuItem("Edit flags...");
        private final JMenuItem profile = new JMenuItem("Profile...");
        private final String name;

        public UserMenuImpl(String name) {
            this.name = name;
            this.nameItem = new JMenuItem(name);
            this.ban.setIcon(MenuIcons.getIcon("ban"));
            this.banMessage.setIcon(MenuIcons.getIcon("banm"));
            this.kick.setIcon(MenuIcons.getIcon("boot"));
            this.kickMessage.setIcon(MenuIcons.getIcon("bootm"));
            this.squelch.setIcon(MenuIcons.getIcon("squelch"));
            this.unsquelch.setIcon(MenuIcons.getIcon("unsquelch"));
            this.designate.setIcon(MenuIcons.getIcon("designate"));
            this.op.setIcon(MenuIcons.getIcon("op"));
            this.edit.setIcon(MenuIcons.getIcon("flags"));
            this.profile.setIcon(MenuIcons.getIcon("profile"));
            this.add(this.nameItem);
            this.addSeparator();
            this.add(this.whisper);
            this.add(this.ban);
            this.add(this.banMessage);
            this.add(this.kick);
            this.add(this.kickMessage);
            this.addSeparator();
            this.add(this.squelch);
            this.add(this.unsquelch);
            this.addSeparator();
            this.add(this.designate);
            this.add(this.op);
            this.addSeparator();
            this.add(this.edit);
            this.addSeparator();
            this.add(this.profile);
            this.nameItem.setEnabled(false);
            this.whisper.addActionListener(this);
            this.ban.addActionListener(this);
            this.banMessage.addActionListener(this);
            this.kick.addActionListener(this);
            this.kickMessage.addActionListener(this);
            this.squelch.addActionListener(this);
            this.unsquelch.addActionListener(this);
            this.designate.addActionListener(this);
            this.op.addActionListener(this);
            this.edit.addActionListener(this);
            this.profile.addActionListener(this);
            int i = 0;
            while (i < JavaOpUserMenu.this.items.size()) {
                if (JavaOpUserMenu.this.items.get(i) == JavaOpUserMenu.this.separator) {
                    this.addSeparator();
                } else {
                    String itemName = (String)JavaOpUserMenu.this.items.get(i);
                    JMenuItem item = new JMenuItem(itemName);
                    item.addActionListener(this);
                    this.add(item);
                    Icon icon = (Icon)JavaOpUserMenu.this.icons.get(itemName);
                    if (icon != null) {
                        item.setIcon(icon);
                    }
                }
                ++i;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == this.whisper) {
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/whisper " + this.name + " " + JavaOpUserMenu.this.pubFuncs.getChatboxInput().getText(), 0);
                    JavaOpUserMenu.this.pubFuncs.getChatboxInput().setText(null);
                } else if (e.getSource() == this.ban) {
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/ban " + this.name, 51);
                } else if (e.getSource() == this.banMessage) {
                    String message = JOptionPane.showInputDialog(this, (Object)"Message to ban with?");
                    if (message != null) {
                        JavaOpUserMenu.this.pubFuncs.sendTextPriority("/ban " + this.name + " " + message, 51);
                    }
                } else if (e.getSource() == this.kick) {
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/kick " + this.name, 51);
                } else if (e.getSource() == this.kickMessage) {
                    String message = JOptionPane.showInputDialog(this, (Object)"Message to kick with?");
                    if (message != null) {
                        JavaOpUserMenu.this.pubFuncs.sendTextPriority("/kick " + this.name + " " + message, 51);
                    }
                } else if (e.getSource() == this.squelch) {
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/squelch " + this.name, 51);
                } else if (e.getSource() == this.unsquelch) {
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/unsquelch " + this.name, 51);
                } else if (e.getSource() == this.designate) {
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/designate " + this.name, 51);
                } else if (e.getSource() == this.op) {
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/designate " + this.name, 51);
                    JavaOpUserMenu.this.pubFuncs.sendTextPriority("/resign", 51);
                } else if (e.getSource() == this.edit) {
                    new UserDatabaseWizard(JavaOpUserMenu.this.pubFuncs, this.name);
                } else {
                    ActionListener listener = (ActionListener)JavaOpUserMenu.this.actions.get(((JMenuItem)e.getSource()).getText());
                    if (listener == null) {
                        JOptionPane.showMessageDialog(null, "To-do");
                    } else {
                        ActionEvent newEvent = new ActionEvent(((JMenuItem)e.getSource()).getText(), 1, this.name);
                        listener.actionPerformed(newEvent);
                    }
                }
            }
            catch (Exception exc) {
                JavaOpUserMenu.this.pubFuncs.systemMessage(5, "Unable to complete command: " + exc);
            }
        }
    }
}

