/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui;

import com.javaop.SwingGui.JavaOpBotMenu;
import com.javaop.SwingGui.JavaOpUserMenu;
import com.javaop.SwingGui.gui.ChannelList;
import com.javaop.SwingGui.gui.ColorTextArea;
import com.javaop.SwingGui.gui.TextFieldHistory;
import com.javaop.SwingGui.util.GameIcons;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.LoginException;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.ErrorCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GuiCallback;
import com.javaop.plugin_interfaces.OutgoingTextCallback;
import com.javaop.plugin_interfaces.SystemMessageCallback;
import com.javaop.users.Statstring;
import com.javaop.util.BnetEvent;
import com.javaop.util.BnetPacket;
import com.javaop.util.ColorConstants;
import com.javaop.util.PadString;
import com.javaop.util.Timestamp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class JavaOpPanel
extends JInternalFrame
implements FocusListener,
InternalFrameListener,
MouseListener,
ActionListener,
GuiCallback,
EventCallback,
OutgoingTextCallback,
SystemMessageCallback,
ErrorCallback,
CommandCallback {
    private static final long serialVersionUID = 1L;
    private final PublicExposedFunctions out;
    private final ColorTextArea chatWindow;
    private final ChannelList channelList;
    private final TextFieldHistory input;
    private final JButton send;
    private final JLabel channelName;
    private final JavaOpBotMenu menu;
    private final JavaOpUserMenu userMenu;
    private String name = "Swing Gui";
    private String channel = "<Not Logged In>";
    private String lastWhisperTo = null;
    private String lastWhisperFrom = null;

    public JavaOpPanel(PublicExposedFunctions out, FocusTraversalPolicy policy) {
        super(out.getName(), true, true, true, true);
        this.out = out;
        this.menu = new JavaOpBotMenu(out, this);
        this.setJMenuBar(this.menu);
        this.userMenu = new JavaOpUserMenu(out);
        this.setFrameIcon(GameIcons.getIcon(out.getLocalSetting("Battle.net Login Plugin", "Game")));
        this.getContentPane().setLayout(new BorderLayout());
        this.addInternalFrameListener(this);
        this.setFocusTraversalPolicy(policy);
        this.addFocusListener(this);
        this.setDefaultCloseOperation(0);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BorderLayout());
        this.input = new TextFieldHistory(500);
        inputPanel.add((Component)this.input, "Center");
        this.send = new JButton("Send");
        inputPanel.add((Component)this.send, "East");
        out.setChatboxInput((JTextField)this.input);
        this.channelList = new ChannelList(out.getLocalSettingDefault(this.name, "Ops on top", "true").equalsIgnoreCase("true"));
        JScrollPane scroller = new JScrollPane(this.channelList);
        JPanel channelPanel = new JPanel();
        channelPanel.setLayout(new BorderLayout());
        this.channelName = new JLabel("Channel", 0);
        channelPanel.add((Component)this.channelName, "North");
        channelPanel.add((Component)scroller, "East");
        int maxChars = Integer.parseInt(out.getLocalSettingDefault(this.name, "chat max length", "100000"));
        int cutTo = Integer.parseInt(out.getLocalSettingDefault(this.name, "chat reset length", "80000"));
        boolean holdAtBottom = out.getLocalSettingDefault(this.name, "chat max length", "false").equalsIgnoreCase("true");
        String fontName = out.getLocalSettingDefault(this.name, "font", "Serif");
        int fontSize = Integer.parseInt(out.getLocalSettingDefault(this.name, "Font size", "15"));
        this.chatWindow = new ColorTextArea(Color.BLACK, Color.WHITE, maxChars, cutTo, holdAtBottom);
        this.chatWindow.setFont(new Font(fontName, 0, fontSize));
        this.chatWindow.setMargin(new Insets(5, 5, 5, 5));
        this.getContentPane().add((Component)new JScrollPane(this.chatWindow), "Center");
        this.getContentPane().add((Component)channelPanel, "East");
        this.getContentPane().add((Component)inputPanel, "South");
        this.setOpaque(true);
        this.setBackground(Color.BLACK);
        this.channelName.setOpaque(true);
        this.channelName.setBackground(Color.BLACK);
        this.channelName.setForeground(Color.WHITE);
        this.channelName.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.channelList.setOpaque(true);
        this.channelList.setBackground(Color.BLACK);
        this.channelList.setSelectionBackground(Color.BLACK);
        this.channelList.setSelectionForeground(Color.LIGHT_GRAY);
        this.channelList.setRowSelectionAllowed(true);
        this.channelList.addMouseListener(this);
        this.chatWindow.setEditable(false);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.input.setBackground(Color.BLACK);
        this.input.setForeground(Color.WHITE);
        this.input.setSelectionColor(Color.LIGHT_GRAY);
        this.input.addActionListener(this);
        this.input.setCaretColor(Color.WHITE);
        this.send.setBackground(Color.WHITE);
        this.send.setForeground(Color.BLACK);
        this.send.addActionListener(this);
        scroller.setPreferredSize(new Dimension(200, 1000));
        scroller.getViewport().setBackground(Color.BLACK);
    }

    public void registerCallbacks(PluginCallbackRegister register) {
        register.registerEventPlugin((EventCallback)this, null);
        register.registerOutgoingTextPlugin((OutgoingTextCallback)this, null);
        register.registerErrorPlugin((ErrorCallback)this, null);
        register.registerGuiPlugin((GuiCallback)this, null);
        register.registerSystemMessagePlugin((SystemMessageCallback)this, 0, 8, null);
        register.registerCommandPlugin((CommandCallback)this, "reply", 1, false, "U", "<message>", "Whispers a message back to the last person who sent a message", null);
        register.registerCommandPlugin((CommandCallback)this, "rewhisper", 1, false, "U", "<message>", "Whispers a message to the last person a message was whispered to", null);
        this.out.addAlias("reply", "r");
        this.out.addAlias("reply", "re");
        this.out.addAlias("rewhisper", "rw");
    }

    public void addUser(String user, String client, String clan, int ping, int flags) {
        this.channelList.addUser(user, client, clan, ping, flags);
        this.channelName.setText(String.valueOf(this.channel) + " (" + this.channelList.getRowCount() + ")");
    }

    public void removeUser(String user) {
        this.channelList.removeUser(user);
        this.channelName.setText(String.valueOf(this.channel) + " (" + this.channelList.getRowCount() + ")");
    }

    public void addText(String text) {
        this.chatWindow.addText(text);
        this.channelName.setText(String.valueOf(this.channel) + " (" + this.channelList.getRowCount() + ")");
    }

    public void joinChannel(String channel) {
        this.channel = channel;
        this.channelList.clear();
        this.channelName.setText(String.valueOf(channel) + " (" + this.channelList.getRowCount() + ")");
    }

    public void clear() {
        this.chatWindow.setText("");
        this.chatWindow.addText(String.valueOf(ColorConstants.getColor((String)"info")) + "Chat window cleared\n");
    }

    private boolean doCommand(String str) throws IOException, PluginException {
        if (str.length() > 2 && str.charAt(0) == '/') {
            String[] commandArg = str.substring(1).split(" ", 2);
            return this.out.raiseCommand(null, commandArg[0], commandArg.length == 2 ? commandArg[1] : "", 3, false);
        }
        return false;
    }

    public void selectInput() {
        this.input.requestFocus();
        this.input.selectAll();
    }

    public String getBotName() {
        return this.out.getName();
    }

    public void select() {
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.input.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.input.getText().length() == 0) {
            return;
        }
        try {
            if (this.out != null && !this.doCommand(this.input.getText())) {
                this.out.sendTextPriority(this.input.getText(), 101);
            }
            this.chatWindow.setSelectionStart(this.chatWindow.getText().length());
            this.chatWindow.setSelectionEnd(this.chatWindow.getText().length());
            this.input.setText("");
        }
        catch (Exception exception) {
            this.input.selectAll();
            exception.printStackTrace();
        }
        this.input.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int y;
        int x = e.getX();
        String name = (String)this.channelList.getValueAt(this.channelList.rowAtPoint(new Point(x, y = e.getY())), 1);
        if (name == null) {
            return;
        }
        if (e.getButton() == 3 || (e.getModifiersEx() & 0x80) > 0) {
            this.userMenu.getMenu(name).show(this.channelList, x, y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void menuItemAdded(String name, String whichMenu, int index, char mnemonic, KeyStroke hotkey, Icon icon, ActionListener callback, Object data) {
        this.menu.addItem(name, whichMenu, index, mnemonic, hotkey, icon, callback);
    }

    public void menuItemRemoved(String name, String whichMenu, Object data) {
        this.menu.removeItem(name, whichMenu);
    }

    public void menuSeparatorAdded(String whichMenu, Object data) {
        this.menu.addSeparator(whichMenu);
    }

    public void menuAdded(String name, int index, char mnemonic, Icon icon, ActionListener callback, Object data) {
        this.menu.addMenu(name, index, mnemonic, icon, callback);
    }

    public void menuRemoved(String name, Object data) {
        this.menu.removeMenu(name);
    }

    public void userMenuAdded(String name, int index, Icon icon, ActionListener callback, Object data) {
        this.userMenu.addItem(name, index, icon, callback);
    }

    public void userMenuRemoved(String name, Object data) {
        this.userMenu.removeItem(name);
    }

    public void userMenuSeparatorAdded(Object data) {
        this.userMenu.addSeparator();
    }

    private String colorMessage(String message) {
        if (this.out.getLocalSettingDefault(this.name, "Colored names", "true").equalsIgnoreCase("true")) {
            Random r = new Random(message.hashCode());
            String green = PadString.padHex((int)(r.nextInt(115) + 70), (int)2);
            String blue = PadString.padHex((int)(r.nextInt(115) + 70), (int)2);
            String red = PadString.padHex((int)(r.nextInt(115) + 70), (int)2);
            String color = String.valueOf(red) + green + blue;
            message = String.valueOf('\u8000') + color + message;
        }
        return message;
    }

    public void talk(String user, String statstring, int ping, int flags) throws PluginException {
        if ((flags & 2) > 0) {
            this.display(String.valueOf(ColorConstants.getColor((String)"Op talk brackets")) + "<" + ColorConstants.getColor((String)"Op talk name") + this.colorMessage(user) + ColorConstants.getColor((String)"Op talk brackets") + "> " + ColorConstants.getColor((String)"Op talk text") + statstring);
        } else if ((flags & 1) > 0) {
            this.display(String.valueOf(ColorConstants.getColor((String)"Blizzard talk brackets")) + "<" + ColorConstants.getColor((String)"Blizzard talk name") + this.colorMessage(user) + ColorConstants.getColor((String)"Blizzard talk brackets") + "> " + ColorConstants.getColor((String)"Blizzard talk text") + statstring);
        } else {
            this.display(String.valueOf(ColorConstants.getColor((String)"Talk brackets")) + "<" + ColorConstants.getColor((String)"Talk name") + this.colorMessage(user) + ColorConstants.getColor((String)"Talk brackets") + "> " + ColorConstants.getColor((String)"Talk text") + statstring);
        }
    }

    public void emote(String user, String statstring, int ping, int flags) throws PluginException {
        this.display(String.valueOf(ColorConstants.getColor((String)"Emote brackets")) + "<" + ColorConstants.getColor((String)"Emote name") + this.colorMessage(user) + " " + ColorConstants.getColor((String)"Emote message") + statstring + ColorConstants.getColor((String)"Emote brackets") + ">");
    }

    public void whisperFrom(String user, String statstring, int ping, int flags) throws PluginException {
        this.lastWhisperFrom = user;
        this.display(String.valueOf(ColorConstants.getColor((String)"Whisper from brackets")) + "<" + ColorConstants.getColor((String)"Whisper from name") + "From: " + this.colorMessage(user) + ColorConstants.getColor((String)"Whisper from brackets") + "> " + ColorConstants.getColor((String)"Whisper from message") + statstring);
    }

    public void whisperTo(String user, String statstring, int ping, int flags) throws PluginException {
        this.lastWhisperTo = user;
        this.display(String.valueOf(ColorConstants.getColor((String)"Whisper to brackets")) + "<" + ColorConstants.getColor((String)"Whisper to name") + "To: " + this.colorMessage(user) + ColorConstants.getColor((String)"Whisper to brackets") + "> " + ColorConstants.getColor((String)"Whisper to message") + statstring);
    }

    public void userShow(String user, String statstring, int ping, int flags) throws PluginException {
        if (this.out.getLocalSettingDefault(this.name, "Show join/leave", "true").equalsIgnoreCase("true")) {
            this.display(String.valueOf(ColorConstants.getColor((String)"User show name")) + this.colorMessage(user) + ColorConstants.getColor((String)"User show message") + " is in the channel " + ColorConstants.getColor((String)"User show info") + "(ping: " + ping + ", flags: " + flags + ")");
        }
        Statstring ss = new Statstring(statstring);
        this.addUser(user, ss.getClient(), ss.getClan(), ping, flags);
    }

    public void userJoin(String user, String statstring, int ping, int flags) throws PluginException {
        if (this.out.getLocalSettingDefault(this.name, "Show join/leave", "true").equalsIgnoreCase("true")) {
            this.display(String.valueOf(ColorConstants.getColor((String)"User join name")) + this.colorMessage(user) + ColorConstants.getColor((String)"User join message") + " has joined the channel " + ColorConstants.getColor((String)"User join info") + "(ping: " + ping + ", flags: " + flags + ")");
        }
        Statstring ss = new Statstring(statstring);
        this.addUser(user, ss.getClient(), ss.getClan(), ping, flags);
    }

    public void userLeave(String user, String statstring, int ping, int flags) throws PluginException {
        if (this.out.getLocalSettingDefault(this.name, "Show join/leave", "true").equalsIgnoreCase("true")) {
            this.display(String.valueOf(ColorConstants.getColor((String)"User leave name")) + this.colorMessage(user) + ColorConstants.getColor((String)"User leave message") + " has left the channel " + ColorConstants.getColor((String)"User leave info") + "(ping: " + ping + ", flags: " + flags + ")");
        }
        this.removeUser(user);
    }

    public void userFlags(String user, String statstring, int ping, int flags) throws PluginException {
        Statstring ss;
        if (this.out.getLocalSettingDefault(this.name, "Show status updates", "false").equalsIgnoreCase("true")) {
            this.display(String.valueOf(ColorConstants.getColor((String)"User update name")) + this.colorMessage(user) + ColorConstants.getColor((String)"User update message") + " has had a status update " + ColorConstants.getColor((String)"User update info") + "(ping: " + ping + ", flags: " + flags + ")");
        }
        String client = (ss = new Statstring(statstring)).getClient() != null ? ss.getClient() : "CHAT";
        String clan = ss.getClan() != null ? ss.getClan() : "";
        this.addUser(user, client, clan, ping, flags);
    }

    public void error(String user, String statstring, int ping, int flags) throws PluginException {
        this.display(String.valueOf(ColorConstants.getColor((String)"Error")) + statstring);
    }

    public void info(String user, String statstring, int ping, int flags) throws PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "Show away", "false").equalsIgnoreCase("false")) {
            if (statstring.equalsIgnoreCase("You are now marked as being away.")) {
                return;
            }
            if (statstring.equalsIgnoreCase("You are still marked as being away.")) {
                return;
            }
            if (statstring.equalsIgnoreCase("You are no longer marked as away.")) {
                return;
            }
        }
        this.display(String.valueOf(ColorConstants.getColor((String)"Info")) + statstring);
    }

    public void broadcast(String user, String statstring, int ping, int flags) throws PluginException {
        this.display(String.valueOf(ColorConstants.getColor((String)"Broadcast")) + statstring);
    }

    public void channel(String user, String statstring, int ping, int flags) throws PluginException {
        this.display(String.valueOf(ColorConstants.getColor((String)"Channel text")) + "Joining channel: " + ColorConstants.getColor((String)"Channel name") + statstring);
        this.joinChannel(statstring);
    }

    private void display(String message) {
        this.addText(String.valueOf(ColorConstants.getColor((String)"Timestamp")) + Timestamp.getTimestamp() + message + "\n");
    }

    public String queuingText(String text, Object data) {
        return text;
    }

    public void queuedText(String text, Object data) {
    }

    public String nextInLine(String text, Object data) {
        return text;
    }

    public long getDelay(String text, Object data) {
        return 0L;
    }

    public boolean sendingText(String text, Object data) {
        return true;
    }

    public void sentText(String text, Object data) {
        boolean isCommand;
        if (text.length() == 0) {
            return;
        }
        boolean showCommands = this.out.getLocalSettingDefault(this.getName(), "Show \"/commands\"", "false").equalsIgnoreCase("true");
        boolean bl = isCommand = text.charAt(0) == '/';
        if (showCommands || !isCommand) {
            this.display(String.valueOf(ColorConstants.getColor((String)"Me talk brackets")) + "<" + ColorConstants.getColor((String)"Me talk name") + this.colorMessage((String)this.out.getLocalVariable((Object)"username")) + ColorConstants.getColor((String)"Me talk brackets") + "> " + ColorConstants.getColor((String)"Me talk text") + text);
        }
    }

    private int getMinimumMessageLevel() {
        String loudness = this.out.getStaticExposedFunctionsHandle().getGlobalSettingDefault(this.getName(), "loudness", "debug");
        if (loudness.equalsIgnoreCase("PACKET")) {
            return 0;
        }
        if (loudness.equalsIgnoreCase("DEBUG")) {
            return 1;
        }
        if (loudness.equalsIgnoreCase("INFO")) {
            return 2;
        }
        if (loudness.equalsIgnoreCase("NOTICE")) {
            return 3;
        }
        if (loudness.equalsIgnoreCase("WARNING")) {
            return 4;
        }
        if (loudness.equalsIgnoreCase("ERROR")) {
            return 5;
        }
        if (loudness.equalsIgnoreCase("CRITICAL")) {
            return 6;
        }
        if (loudness.equalsIgnoreCase("ALERT")) {
            return 7;
        }
        if (loudness.equalsIgnoreCase("EMERGENCY")) {
            return 8;
        }
        return 1;
    }

    public void systemMessage(int level, String message, Object data) {
        int minMessage = this.getMinimumMessageLevel();
        if (minMessage > level) {
            return;
        }
        switch (level) {
            case 1: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 1 Debug")) + errorLevelConstants[level] + ": " + message);
                break;
            }
            case 2: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 2 Info")) + errorLevelConstants[level] + ": " + message);
                break;
            }
            case 3: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 3 Notice")) + errorLevelConstants[level] + ": " + message);
                break;
            }
            case 4: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 4 Warning")) + errorLevelConstants[level] + ": " + message);
                break;
            }
            case 5: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 5 Error")) + errorLevelConstants[level] + ": " + message);
                break;
            }
            case 6: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 6 Critical")) + errorLevelConstants[level] + ": " + message);
                break;
            }
            case 7: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 7 Alert")) + errorLevelConstants[level] + ": " + message);
                break;
            }
            case 8: {
                this.display(String.valueOf(ColorConstants.getColor((String)"Error 8 Emergency")) + errorLevelConstants[level] + ": " + message);
            }
        }
    }

    public void showMessage(String message, Object data) {
        this.display(message);
    }

    public void unknownPacketReceived(BnetPacket packet, Object data) {
        if (this.getMinimumMessageLevel() > 5) {
            return;
        }
        this.display(String.valueOf(ColorConstants.getColor((String)"Error unknown packet")) + "Unknown packet received:");
        this.display(String.valueOf(ColorConstants.getColor((String)"Error unknown packet")) + packet);
    }

    public void unknownEventReceived(BnetEvent event, Object data) {
        if (this.getMinimumMessageLevel() > 5) {
            return;
        }
        this.display(String.valueOf(ColorConstants.getColor((String)"Error unknown event")) + "Unknown event received:");
        this.display(String.valueOf(ColorConstants.getColor((String)"Error unknown event")) + event);
    }

    public void loginException(LoginException e, Object data) {
        if (this.getMinimumMessageLevel() > 5) {
            return;
        }
        this.display(String.valueOf(ColorConstants.getColor((String)"Error")) + "Login Exception:");
        this.displayError((Throwable)e);
    }

    public void ioException(IOException e, Object data) {
        if (this.getMinimumMessageLevel() > 5) {
            return;
        }
        this.display(String.valueOf(ColorConstants.getColor((String)"Error")) + "IO Exception:");
        this.displayError(e);
    }

    public void unknownException(Exception e, Object data) {
        if (this.getMinimumMessageLevel() > 5) {
            return;
        }
        this.display(String.valueOf(ColorConstants.getColor((String)"Error")) + "Exception:");
        this.displayError(e);
    }

    public void error(Error e, Object data) {
        if (this.getMinimumMessageLevel() > 5) {
            return;
        }
        this.display(String.valueOf(ColorConstants.getColor((String)"Error")) + "Error:");
        this.displayError(e);
    }

    public void pluginException(PluginException e, Object data) {
        if (this.getMinimumMessageLevel() > 5) {
            return;
        }
        this.displayError((Throwable)e);
    }

    public void displayError(Throwable t) {
        StackTraceElement[] stack = t.getStackTrace();
        this.display(String.valueOf(ColorConstants.getColor((String)"Error")) + t);
        int i = 0;
        while (i < stack.length) {
            this.display(String.valueOf(ColorConstants.getColor((String)"Error")) + stack[i]);
            ++i;
        }
    }

    public void commandExecuted(String user, String command, String[] args, int loudness, Object data) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (command.equalsIgnoreCase("say")) {
            if (args.length == 0) {
                throw new CommandUsedImproperly("What do you want to say?", user, command);
            }
        } else if (command.equalsIgnoreCase("reply")) {
            if (this.lastWhisperFrom == null) {
                this.out.sendTextUser(user, "Error: no last incoming whisper", loudness);
            } else {
                this.out.sendText("/w " + this.lastWhisperFrom + " " + args[0]);
            }
        } else if (command.equalsIgnoreCase("rewhisper")) {
            if (this.lastWhisperTo == null) {
                this.out.sendTextUser(user, "Error: no last outgoing whisper", loudness);
            } else {
                this.out.sendText("/w " + this.lastWhisperTo + " " + args[0]);
            }
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent arg0) {
        this.selectInput();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent arg0) {
        try {
            this.out.getStaticExposedFunctionsHandle().botStop(this.out.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent arg0) {
        this.selectInput();
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent arg0) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.selectInput();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }
}

