/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui;

import com.javaop.SwingGui.JavaOpFrame;
import com.javaop.SwingGui.JavaOpPanel;
import com.javaop.SwingGui.gui.LoadWebsite;
import com.javaop.SwingGui.settings.GlobalSettingWizard;
import com.javaop.SwingGui.util.MenuIcons;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.PluginException;
import com.javaop.util.PersistantMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JavaOpMainMenu
extends JMenuBar
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private final JavaOpFrame frame;
    private final StaticExposedFunctions staticFuncs;
    private static boolean check = false;
    private final JMenu file;
    private final JMenu settings;
    private final JMenu windows;
    private final JMenu help;
    private final JMenu loadBot = new JMenu("Load bot");
    private final JMenu deleteBot = new JMenu("Delete bot");
    private final JMenu defaultBots = new JMenu("Load on startup");
    private final JMenuItem createNew = new JMenuItem("New bot...");
    private final JMenuItem exit = new JMenuItem("Exit");
    private final JMenuItem configureG = new JMenuItem("Global settings...");
    private final JMenuItem maximizeAll = new JMenuItem("Maximize All");
    private final JMenuItem minimizeAll = new JMenuItem("Minimize All");
    private final JMenuItem cascade = new JMenuItem("Cascade");
    private final JMenuItem tile = new JMenuItem("Tile");
    private final JMenuItem news = new JMenuItem("News...");
    private final JMenuItem introduction = new JMenuItem("Introduction...");
    private final JMenuItem botSetup = new JMenuItem("Bot setup...");
    private final JMenuItem moderation = new JMenuItem("Moderation...");
    private final JMenuItem writingPlugins = new JMenuItem("Writing plugins...");
    private final JMenuItem faq = new JMenuItem("FAQ...");
    private final JMenuItem credits = new JMenuItem("Credits...");
    private final BotLoader loader = new BotLoader();
    private final BotDelete deleter = new BotDelete();
    private final BotChecker checker = new BotChecker();
    private final JDesktopPane desktop;

    public JavaOpMainMenu(StaticExposedFunctions staticFuncs, JDesktopPane desktop, JavaOpFrame frame) {
        this.staticFuncs = staticFuncs;
        this.desktop = desktop;
        this.frame = frame;
        if (check) {
            System.err.println("ERROR! Loading JavaOpMainMenu more than once!");
            System.exit(1);
        }
        check = true;
        this.loadBot.setIcon(MenuIcons.getIcon("loadbot"));
        this.deleteBot.setIcon(MenuIcons.getIcon("deletebot"));
        this.defaultBots.setIcon(MenuIcons.getIcon("los"));
        this.createNew.addActionListener(this);
        this.createNew.setMnemonic('n');
        this.createNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.createNew.setIcon(MenuIcons.getIcon("newbot"));
        this.exit.addActionListener(this);
        this.exit.setMnemonic('x');
        this.exit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.exit.setIcon(MenuIcons.getIcon("exit"));
        this.file = new JMenu("File");
        this.file.add(this.createNew);
        this.file.addSeparator();
        this.file.add(this.loadBot);
        this.file.add(this.deleteBot);
        this.file.add(this.defaultBots);
        this.file.addSeparator();
        this.file.add(this.exit);
        this.file.setMnemonic('f');
        this.file.addChangeListener(this);
        this.add(this.file);
        this.configureG.addActionListener(this);
        this.configureG.setMnemonic('g');
        this.configureG.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.configureG.setIcon(MenuIcons.getIcon("global"));
        this.settings = new JMenu("Settings");
        this.settings.add(this.configureG);
        this.add(this.settings);
        this.settings.setMnemonic('s');
        this.minimizeAll.addActionListener(this);
        this.minimizeAll.setIcon(MenuIcons.getIcon("minimize"));
        this.maximizeAll.addActionListener(this);
        this.maximizeAll.setIcon(MenuIcons.getIcon("maximize"));
        this.cascade.addActionListener(this);
        this.cascade.setIcon(MenuIcons.getIcon("cascade"));
        this.tile.addActionListener(this);
        this.tile.setIcon(MenuIcons.getIcon("tile"));
        this.windows = new JMenu("Windows");
        this.windows.addChangeListener(this);
        this.add(this.windows);
        this.help = new JMenu("Help");
        this.help.add(this.news);
        this.help.add(this.introduction);
        this.help.add(this.botSetup);
        this.help.add(this.moderation);
        this.help.add(this.writingPlugins);
        this.help.add(this.faq);
        this.help.add(this.credits);
        this.news.addActionListener(new WebpageLoader("http://javaop.googlecode.com"));
        this.news.setMnemonic('n');
        this.news.setIcon(MenuIcons.getIcon("news"));
        this.introduction.addActionListener(new WebpageLoader("http://code.google.com/p/javaop/wiki/Introduction"));
        this.introduction.setMnemonic('i');
        this.introduction.setIcon(MenuIcons.getIcon("intro"));
        this.botSetup.addActionListener(new WebpageLoader("http://code.google.com/p/javaop/wiki/BotSetup"));
        this.botSetup.setMnemonic('b');
        this.botSetup.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.botSetup.setIcon(MenuIcons.getIcon("started"));
        this.moderation.addActionListener(new WebpageLoader("http://www.javaop.com/moderation.html"));
        this.moderation.setMnemonic('m');
        this.moderation.setIcon(MenuIcons.getIcon("mod"));
        this.writingPlugins.addActionListener(new WebpageLoader("http://www.javaop.com/plugins.html"));
        this.writingPlugins.setMnemonic('w');
        this.writingPlugins.setIcon(MenuIcons.getIcon("plug"));
        this.faq.addActionListener(new WebpageLoader("http://www.javaop.com/faq.html"));
        this.faq.setMnemonic('f');
        this.faq.setIcon(MenuIcons.getIcon("faq"));
        this.credits.addActionListener(new WebpageLoader("http://code.google.com/p/javaop/wiki/Contributers"));
        this.credits.setMnemonic('c');
        this.credits.setIcon(MenuIcons.getIcon("credit"));
        this.add(this.help);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.createNew) {
                String name = "";
                while (true) {
                    if ((name = JOptionPane.showInputDialog(null, "Name?", name)) == null) {
                        return;
                    }
                    if (name.matches("[\\w\\_\\-\\.]+")) {
                        this.staticFuncs.newBot(name);
                        return;
                    }
                    JOptionPane.showMessageDialog(null, "Please enter a name containing at least one character, and only the characters a-z, A-Z, 0-9, or '.-_'");
                }
            }
            if (e.getSource() == this.exit) {
                System.exit(0);
            } else if (e.getSource() == this.configureG) {
                new GlobalSettingWizard(this.staticFuncs);
            } else if (e.getSource() == this.maximizeAll) {
                this.frame.maximizeAll();
            } else if (e.getSource() == this.minimizeAll) {
                this.frame.minimizeAll();
            } else if (e.getSource() == this.cascade) {
                this.frame.cascade();
            } else if (e.getSource() == this.tile) {
                this.frame.tile();
            } else {
                JOptionPane.showMessageDialog(null, "Unknown menu event!");
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(null, "Error: " + exc);
            exc.printStackTrace();
        }
    }

    public void updateWindowsMenu() {
        this.windows.removeAll();
        this.windows.add(this.maximizeAll);
        this.windows.add(this.minimizeAll);
        this.windows.add(this.cascade);
        this.windows.add(this.tile);
        this.windows.addSeparator();
        JInternalFrame[] frames = this.desktop.getAllFrames();
        Arrays.sort(frames, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((JavaOpPanel)arg0).getTitle().compareTo(((JavaOpPanel)arg1).getTitle());
            }
        });
        int i = 0;
        while (i < frames.length) {
            JCheckBoxMenuItem thisItem = new JCheckBoxMenuItem(frames[i].getTitle());
            if (i < 9) {
                thisItem.setAccelerator(KeyStroke.getKeyStroke(49 + i, 2));
            }
            if (this.desktop.getSelectedFrame() == frames[i]) {
                thisItem.setSelected(true);
            }
            thisItem.setIcon(frames[i].getFrameIcon());
            thisItem.addActionListener(new BotSelector((JavaOpPanel)frames[i]));
            this.windows.add(thisItem);
            ++i;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.file) {
            this.loadBot.removeAll();
            this.deleteBot.removeAll();
            this.defaultBots.removeAll();
            String[] bots = this.staticFuncs.botGetAllNames();
            int i = 0;
            while (i < bots.length) {
                PersistantMap settings = this.staticFuncs.botGetSettings(bots[i]);
                String info = "'" + settings.getNoWrite("Battle.net Login Plugin", "username", "<unknown>") + "' on '" + settings.getNoWrite(" Default", "server", "<unknown>") + "' in channel '" + settings.getNoWrite("Battle.net Login Plugin", "home channel", "<unknown>") + "'; game: " + settings.getNoWrite("Battle.net Login Plugin", "game", "<unknown>");
                JMenuItem item = new JMenuItem(bots[i]);
                item.setToolTipText(info);
                this.loadBot.add(item);
                item.addActionListener(this.loader);
                item = new JMenuItem(bots[i]);
                item.setToolTipText(info);
                this.deleteBot.add(item);
                item.addActionListener(this.deleter);
                try {
                    JCheckBoxMenuItem check = new JCheckBoxMenuItem(bots[i]);
                    check.setToolTipText(info);
                    check.setSelected(this.staticFuncs.botIsDefault(bots[i]));
                    check.addActionListener(this.checker);
                    this.defaultBots.add(check);
                }
                catch (IOException exc) {
                    this.defaultBots.add(new JMenuItem("Error loading default bots: " + exc));
                }
                ++i;
            }
            if (bots.length == 0) {
                this.loadBot.add("-- No bots, please create new --");
                this.deleteBot.add("-- No bots, please create new --");
                this.defaultBots.add("-- No bots, please create new --");
            }
            this.loadBot.validate();
            this.deleteBot.validate();
            this.defaultBots.validate();
        } else if (e.getSource() == this.windows) {
            this.updateWindowsMenu();
        }
    }

    private class BotChecker
    implements ActionListener {
        private BotChecker() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String name = ((JMenuItem)e.getSource()).getText();
                JavaOpMainMenu.this.staticFuncs.botToggleDefault(name);
            }
            catch (Exception exc) {
                JavaOpMainMenu.this.staticFuncs.systemMessage(5, "Unable to set defaults: " + exc);
            }
        }
    }

    private class BotDelete
    implements ActionListener {
        private BotDelete() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = ((JMenuItem)e.getSource()).getText();
            if (JOptionPane.showConfirmDialog(null, "Are you sure you want to delete bot " + name + "?", "Delete?", 0) == 0) {
                JavaOpMainMenu.this.staticFuncs.botDelete(name);
            }
        }
    }

    private class BotLoader
    implements ActionListener {
        private BotLoader() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String name = ((JMenuItem)e.getSource()).getText();
                if (JavaOpMainMenu.this.frame.getBotByName(name) == null) {
                    JavaOpMainMenu.this.staticFuncs.botStart(name);
                } else {
                    JavaOpMainMenu.this.frame.select(name);
                }
            }
            catch (PluginException exc) {
                JavaOpMainMenu.this.staticFuncs.systemMessage(5, "Unable to start bot: " + (Object)((Object)exc));
            }
            catch (IOException exc) {
                JavaOpMainMenu.this.staticFuncs.systemMessage(5, "Unable to start bot: " + exc);
            }
        }
    }

    private class BotSelector
    implements ActionListener {
        private final JavaOpPanel bot;

        public BotSelector(JavaOpPanel bot) {
            this.bot = bot;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.bot.select();
        }
    }

    class WebpageLoader
    implements ActionListener {
        private final String site;

        public WebpageLoader(String site) {
            this.site = site;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new LoadWebsite(this.site);
        }
    }
}

