/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui;

import com.javaop.SwingGui.JavaOpMainMenu;
import com.javaop.SwingGui.JavaOpPanel;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.util.gui.Gui;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;

public class JavaOpFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Hashtable<String, JavaOpPanel> bots = new Hashtable();
    private final JDesktopPane desktop;
    private final JavaOpMainMenu menu;
    private int x = 1000000000;
    private int y = 1000000000;
    int minx = 5;
    int miny = 5;
    private final int width = 600;
    private final int height = 400;
    private final int locationIncrement = 20;

    public JavaOpFrame(StaticExposedFunctions staticFuncs) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle("JavaOp2 " + staticFuncs.getVersion() + " -- javaop.googlecode.com");
        this.desktop = new JDesktopPane();
        this.setContentPane(this.desktop);
        this.menu = new JavaOpMainMenu(staticFuncs, this.desktop, this);
        this.setJMenuBar(this.menu);
        this.setSize(800, 500);
        this.desktop.setBackground(Color.BLACK);
        this.desktop.setForeground(Color.WHITE);
        Gui.center((Window)this);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public JavaOpPanel addBot(PublicExposedFunctions out) {
        JavaOpPanel bot = this.bots.get(out.getName());
        if (bot != null) {
            this.select(out.getName());
        } else {
            MyOwnFocusTraversalPolicy policy = new MyOwnFocusTraversalPolicy();
            bot = new JavaOpPanel(out, policy);
            this.bots.put(out.getName(), bot);
            this.desktop.add(bot);
            this.placeNext(bot);
            this.setFocusTraversalPolicy(policy);
            bot.setVisible(true);
        }
        this.menu.updateWindowsMenu();
        return bot;
    }

    public void removeBot(String name) {
        JavaOpPanel bot = this.bots.get(name);
        if (bot != null) {
            bot.dispose();
            this.bots.remove(name);
        }
        this.menu.updateWindowsMenu();
        this.invalidate();
        this.validate();
    }

    public void select(String name) {
        JavaOpPanel bot = this.bots.get(name);
        if (bot != null) {
            bot.select();
        }
    }

    public String getCurrentbot() {
        return ((JavaOpPanel)this.desktop.getSelectedFrame()).getBotName();
    }

    public JavaOpPanel getBotByName(String name) {
        return this.bots.get(name);
    }

    public void minimizeAll() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            try {
                frames[i].setIcon(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void maximizeAll() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            try {
                frames[i].setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            try {
                frames[i].setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void cascade() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        Arrays.sort(frames, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((JavaOpPanel)arg0).getTitle().compareTo(((JavaOpPanel)arg1).getTitle());
            }
        });
        this.x = 100000000;
        this.y = 100000000;
        int i = 0;
        while (i < frames.length) {
            if (!frames[i].isIcon()) {
                this.placeNext((JavaOpPanel)frames[i]);
            }
            ++i;
        }
    }

    public void tile() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        Arrays.sort(frames, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((JavaOpPanel)arg0).getTitle().compareTo(((JavaOpPanel)arg1).getTitle());
            }
        });
        int cols = (int)Math.sqrt(frames.length);
        int rows = (int)Math.ceil((double)frames.length / (double)cols);
        int width = this.getWidth() / cols;
        int height = (this.getHeight() - 55) / rows;
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < frames.length) {
            frames[i].setSize(width, height);
            frames[i].setLocation(x * width, y * height);
            if (++x >= cols) {
                x = 0;
                ++y;
            }
            ++i;
        }
    }

    private void placeNext(JavaOpPanel bot) {
        bot.setSize(600, 400);
        this.x += 20;
        this.y += 20;
        if (this.x + 600 > this.desktop.getWidth()) {
            this.x = this.minx;
        }
        if (this.y + 400 > this.desktop.getHeight()) {
            this.y = this.miny;
        }
        bot.setLocation(this.x, this.y);
        bot.toFront();
        bot.select();
    }

    private class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private MyOwnFocusTraversalPolicy() {
        }

        private JavaOpPanel findPanel(Component parent) {
            while (parent != null && !(parent instanceof JavaOpPanel)) {
                parent = parent.getParent();
            }
            return (JavaOpPanel)parent;
        }

        private JInternalFrame[] getFrames() {
            JInternalFrame[] frames = JavaOpFrame.this.desktop.getAllFrames();
            Arrays.sort(frames, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((JavaOpPanel)arg0).getTitle().compareTo(((JavaOpPanel)arg1).getTitle());
                }
            });
            return frames;
        }

        private JavaOpPanel selectFrame(JavaOpPanel panel) {
            panel.select();
            return panel;
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            JInternalFrame[] frames = this.getFrames();
            JavaOpPanel panel = this.findPanel(aComponent);
            if (panel == null) {
                return aComponent;
            }
            int i = 0;
            while (i < frames.length) {
                if (frames[i] == panel) {
                    return this.selectFrame((JavaOpPanel)frames[(i + 1) % frames.length]);
                }
                ++i;
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            JInternalFrame[] frames = this.getFrames();
            JavaOpPanel panel = this.findPanel(aComponent);
            if (panel == null) {
                return aComponent;
            }
            int i = 0;
            while (i < frames.length) {
                if (frames[i] == panel) {
                    return this.selectFrame((JavaOpPanel)frames[(i - 1 + frames.length) % frames.length]);
                }
                ++i;
            }
            return this.getDefaultComponent(focusCycleRoot);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            JInternalFrame[] frames = this.getFrames();
            return frames.length > 0 ? frames[0] : focusCycleRoot;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            JInternalFrame[] frames = this.getFrames();
            return frames.length > 0 ? frames[frames.length - 1] : focusCycleRoot;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            JInternalFrame[] frames = this.getFrames();
            return frames.length > 0 ? frames[0] : focusCycleRoot;
        }
    }
}

