/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.SwingGui;

import com.javaop.SwingGui.JavaOpPanel;
import com.javaop.SwingGui.settings.QuickSettings;
import com.javaop.SwingGui.settings.SettingWizard;
import com.javaop.SwingGui.settings.UserDatabaseWizard;
import com.javaop.SwingGui.util.MenuIcons;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.util.ColorConstants;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class JavaOpBotMenu
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JMenu file;
    private final JMenu edit;
    private final JMenu connection;
    private final JMenu settings;
    private final JMenuItem reload = new JMenuItem("Reload");
    private final JMenuItem close = new JMenuItem("Close");
    private final JMenuItem clear = new JMenuItem("Clear");
    private final JMenuItem connect = new JMenuItem("Connect");
    private final JMenuItem reconnect = new JMenuItem("Reconnect");
    private final JMenuItem disconnect = new JMenuItem("Disconnect");
    private final JMenuItem quickConfigure = new JMenuItem("Quick configuration...");
    private final JMenuItem configure = new JMenuItem("This bot's settings...");
    private final JMenuItem userdb = new JMenuItem("Edit database...");
    private final JMenuItem colors = new JMenuItem("Edit colors...");
    private final PublicExposedFunctions out;
    private final JavaOpPanel panel;
    private final Hashtable<String, JMenu> menus = new Hashtable();
    private final Hashtable<JMenuItem, ActionListener> callbacks = new Hashtable();

    public JavaOpBotMenu(PublicExposedFunctions out, JavaOpPanel panel) {
        this.out = out;
        this.panel = panel;
        this.reload.addActionListener(this);
        this.reload.setMnemonic('r');
        this.reload.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.reload.setIcon(MenuIcons.getIcon("reloadbot"));
        this.close.addActionListener(this);
        this.close.setMnemonic('c');
        this.close.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.close.setIcon(MenuIcons.getIcon("closebot"));
        this.file = new JMenu("File");
        this.file.add(this.reload);
        this.file.add(this.close);
        this.file.setMnemonic('f');
        this.add(this.file);
        this.menus.put("file", this.file);
        this.clear.addActionListener(this);
        this.clear.setMnemonic('c');
        this.clear.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.clear.setIcon(MenuIcons.getIcon("clearscreen"));
        this.edit = new JMenu("Edit");
        this.edit.add(this.clear);
        this.add(this.edit);
        this.menus.put("edit", this.edit);
        this.connect.addActionListener(this);
        this.connect.setMnemonic('c');
        this.connect.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.connect.setIcon(MenuIcons.getIcon("connect"));
        this.disconnect.addActionListener(this);
        this.disconnect.setMnemonic('d');
        this.disconnect.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.disconnect.setIcon(MenuIcons.getIcon("disconnect"));
        this.reconnect.addActionListener(this);
        this.reconnect.setMnemonic('r');
        this.reconnect.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.reconnect.setIcon(MenuIcons.getIcon("reconnect"));
        this.connection = new JMenu("Connection");
        this.connection.add(this.connect);
        this.connection.add(this.disconnect);
        this.connection.add(this.reconnect);
        this.connection.setMnemonic('o');
        this.add(this.connection);
        this.menus.put("connection", this.connection);
        this.quickConfigure.addActionListener(this);
        this.quickConfigure.setMnemonic('q');
        this.quickConfigure.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.quickConfigure.setIcon(MenuIcons.getIcon("quick"));
        this.configure.addActionListener(this);
        this.configure.setMnemonic('c');
        this.configure.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.configure.setIcon(MenuIcons.getIcon("setting"));
        this.userdb.addActionListener(this);
        this.userdb.setMnemonic('u');
        this.userdb.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.userdb.setIcon(MenuIcons.getIcon("database"));
        this.colors.addActionListener(this);
        this.colors.setMnemonic('o');
        this.colors.setIcon(MenuIcons.getIcon("color"));
        this.settings = new JMenu("Settings");
        this.settings.add(this.quickConfigure);
        this.settings.addSeparator();
        this.settings.add(this.configure);
        this.settings.add(this.userdb);
        this.settings.add(this.colors);
        this.settings.setMnemonic('s');
        this.add(this.settings);
        this.menus.put("settings", this.settings);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.reload) {
                String name = this.out.getName();
                this.out.getStaticExposedFunctionsHandle().botStop(name);
                this.out.getStaticExposedFunctionsHandle().botStart(name);
            } else if (e.getSource() == this.close) {
                this.out.getStaticExposedFunctionsHandle().botStop(this.out.getName());
            } else if (e.getSource() == this.clear) {
                this.panel.clear();
            } else if (e.getSource() == this.connect) {
                this.out.connect();
            } else if (e.getSource() == this.reconnect) {
                this.out.reconnect();
            } else if (e.getSource() == this.disconnect) {
                this.out.disconnect();
            } else if (e.getSource() == this.quickConfigure) {
                new QuickSettings(this.out);
            } else if (e.getSource() == this.configure) {
                new SettingWizard(this.out);
            } else if (e.getSource() == this.userdb) {
                new UserDatabaseWizard(this.out);
            } else if (e.getSource() == this.colors) {
                ColorConstants.showColorEditor();
            } else {
                ActionListener callback = this.callbacks.get(e.getSource());
                if (callback == null) {
                    JOptionPane.showMessageDialog(null, "Unknown menu event!");
                } else {
                    ActionEvent newEvent = new ActionEvent(((JMenuItem)e.getSource()).getText(), 1, ((JMenuItem)e.getSource()).getText());
                    callback.actionPerformed(newEvent);
                }
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(null, "Error: " + exc);
            exc.printStackTrace();
        }
    }

    public void addItem(String name, String whichMenu, int index, char mnemonic, KeyStroke hotkey, Icon icon, ActionListener callback) {
        JMenu menu = this.menus.get(whichMenu.toLowerCase());
        if (menu == null) {
            menu = new JMenu(whichMenu);
            this.add(menu);
            this.validate();
            this.menus.put(whichMenu.toLowerCase(), menu);
        }
        JMenuItem newItem = new JMenuItem(name);
        newItem.setMnemonic(mnemonic);
        newItem.addActionListener(this);
        if (hotkey != null) {
            menu.setAccelerator(hotkey);
        }
        if (icon != null) {
            menu.setIcon(icon);
        }
        if (index >= 0) {
            menu.add((Component)newItem, index);
        } else {
            menu.add(newItem);
        }
        if (callback != null) {
            this.callbacks.put(newItem, callback);
        }
        this.invalidate();
        this.validate();
    }

    public void removeItem(String name, String whichMenu) {
        JMenu menu = this.menus.get(whichMenu.toLowerCase());
        if (menu == null) {
            return;
        }
        Component[] items = menu.getMenuComponents();
        int i = 0;
        while (i < items.length) {
            if (((JMenuItem)items[i]).getText().equalsIgnoreCase(name)) {
                menu.remove(items[i]);
            }
            ++i;
        }
    }

    public void addSeparator(String whichMenu) {
        JMenu menu = this.menus.get(whichMenu.toLowerCase());
        if (menu == null) {
            menu = new JMenu(whichMenu);
            this.add(menu);
            this.invalidate();
            this.validate();
            this.menus.put(whichMenu.toLowerCase(), menu);
        }
        menu.addSeparator();
    }

    public void addMenu(String name, int index, char mnemonic, Icon icon, ActionListener callback) {
        JMenu menu = this.menus.get(name.toLowerCase());
        if (menu != null) {
            return;
        }
        menu = new JMenu(name);
        menu.setMnemonic(mnemonic);
        if (icon != null) {
            menu.setIcon(icon);
        }
        if (callback != null) {
            menu.addActionListener(callback);
        }
        if (index != -1) {
            this.add((Component)menu, index);
        } else {
            this.add(menu);
        }
        this.invalidate();
        this.validate();
        this.menus.put(name.toLowerCase(), menu);
    }

    public void removeMenu(String name) {
        JMenu menu = this.menus.get(name.toLowerCase());
        if (menu == null) {
            return;
        }
        this.menus.remove(name);
        this.remove(menu);
        this.invalidate();
        this.validate();
        this.repaint();
    }
}

