/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Profile;

import com.javaop.Profile.ProfileRequest;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.FileTime;
import com.javaop.util.TimeReader;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements PacketCallback,
CommandCallback,
EventCallback {
    private int cookie = this.getName().hashCode();
    private Hashtable requests = new Hashtable();
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 38, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 10, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 53, null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "profile", 2, false, "L", "<user> [keys]", "This will get and display the requested profile keys (comma-separated list).  If no keys are specified, it uses the local setting 'default keys'", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "setprofile", 2, false, "N", "<key> <value>", "This will set the requested key to the requested value. Keys are typically profile\\sex, profile\\location, and profile\\description.  If you don't understand this, you can use the SwingGui to set profile data.  Be careful -- the wrong key can get you ipbanned.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "w3profile", 1, false, "L", "<user>", "This will request the profile information for a War3 account", null);
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
        publicExposedFunctions.addAlias("setprofile profile\\sex", "setsex");
        publicExposedFunctions.addAlias("setprofile profile\\age", "setage");
        publicExposedFunctions.addAlias("setprofile profile\\location", "setlocation");
        publicExposedFunctions.addAlias("setprofile profile\\description", "setdescription");
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Profile";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Profile plugin";
    }

    public String getLongDescription() {
        return "This plugin allows the user to change/view their profile on Battle.net.  SwingGUI can show the profile graphically, but this is textbased.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Default keys", "profile\\sex, profile\\age, profile\\location, profile\\description");
        properties.setProperty("Own keys", "profile\\sex, profile\\age, profile\\location, profile\\description, system\\account created, system\\last logon, system\\last logoff, system\\time logged");
        properties.setProperty("Get own profile", "true");
        properties.setProperty("Get all profiles", "false");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Default keys", "The keys that are requested if no profile keys are specified");
        properties.setProperty("Own keys", "The keys that are requested for yourself at login, if that's enabled");
        properties.setProperty("Get own profile", "If enabled, this retrieves and displays your own profile when you log in");
        properties.setProperty("Get all profiles", "If enabled, this retrieves the profile for every user who enters the channel.  Not really recommended, because floodbots might eat you, but eh?");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("Get own profile")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("Get all profiles")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) throws PluginException {
        return bnetPacket;
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        if (bnetPacket.getCode() == 38) {
            bnetPacket.removeDWord();
            bnetPacket.removeDWord();
            int n = bnetPacket.removeDWord();
            ProfileRequest profileRequest = (ProfileRequest)this.requests.remove(n + "");
            if (profileRequest == null) {
                return;
            }
            String[] stringArray = profileRequest.getKeys();
            String string = profileRequest.getRequester();
            String string2 = profileRequest.getUser();
            int n2 = profileRequest.getLoudness();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = bnetPacket.removeNTString();
                if (stringArray[i].equalsIgnoreCase("system\\account created") || stringArray[i].equalsIgnoreCase("system\\last logon") || stringArray[i].equalsIgnoreCase("system\\last logoff")) {
                    string3 = new Date(FileTime.fileTimeToMillis((String)string3.replaceAll(" .*", ""), (String)string3.replaceAll(".* ", ""))).toString();
                } else if (stringArray[i].equalsIgnoreCase("system\\time logged")) {
                    string3 = TimeReader.timeToString((long)(Long.parseLong(string3) * 1000L));
                }
                this.out.sendTextUser(string, "\\" + string2 + "\\" + stringArray[i] + " = " + string3, n2);
            }
        } else if (bnetPacket.getCode() == 53) {
            int n = bnetPacket.removeDWord();
            byte by = bnetPacket.removeByte();
            if (by != 0) {
                return;
            }
            ProfileRequest profileRequest = (ProfileRequest)this.requests.remove(n + "");
            if (profileRequest == null) {
                return;
            }
            String string = profileRequest.getRequester();
            String string4 = profileRequest.getUser();
            int n3 = profileRequest.getLoudness();
            String string5 = bnetPacket.removeNTString();
            String string6 = bnetPacket.removeNTString();
            String string7 = this.getClanTag(bnetPacket.removeString(4));
            this.out.sendTextUser(string, "\\" + string4 + "\\location = " + string6, n3);
            this.out.sendTextUser(string, "\\" + string4 + "\\description = " + string5, n3);
            this.out.sendTextUser(string, "\\" + string4 + "\\clan name = " + string7, n3);
        } else if (bnetPacket.getCode() == 10 && this.out.getLocalSettingDefault(this.getName(), "Get own profile", "true").equalsIgnoreCase("true")) {
            this.out.sendPacket((Buffer)this.getRequest(null, (String)this.out.getLocalVariable((Object)"username"), this.out.getLocalSettingDefault(this.getName(), "Own keys", "profile\\sex, profile\\age, profile\\location, profile\\description, system\\account created, system\\account expires, system\\last logon, system\\last logoff, system\\time logged").split("\\s*,\\s*"), 3));
        }
    }

    private BnetPacket getRequest(String string, String string2, String[] stringArray, int n) {
        ProfileRequest profileRequest = new ProfileRequest(string, string2, stringArray, n);
        this.requests.put(this.cookie + "", profileRequest);
        BnetPacket bnetPacket = new BnetPacket(38);
        bnetPacket.addDWord(1);
        bnetPacket.addDWord(stringArray.length);
        bnetPacket.addDWord(this.cookie);
        bnetPacket.addNTString(string2.replaceAll("\\#.*", ""));
        for (int i = 0; i < stringArray.length; ++i) {
            bnetPacket.addNTString(stringArray[i]);
        }
        ++this.cookie;
        return bnetPacket;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("profile")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("Profile requires at least 1 key", string, string2);
            }
            String[] stringArray2 = stringArray.length == 2 ? stringArray[1].split("\\s*,\\s*") : this.out.getLocalSettingDefault(this.getName(), "Default keys", "profile\\sex, profile\\age, profile\\location, profile\\description").split("\\s*,\\s*");
            this.out.sendPacket((Buffer)this.getRequest(string, stringArray[0], stringArray2, n));
        } else if (string2.equalsIgnoreCase("setprofile")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("setprofile requires a key", string, string2);
            }
            BnetPacket bnetPacket = new BnetPacket(39);
            bnetPacket.addDWord(1);
            bnetPacket.addDWord(1);
            bnetPacket.addNTString((String)this.out.getLocalVariable((Object)"username"));
            bnetPacket.addNTString(stringArray[0]);
            bnetPacket.addNTString(stringArray.length == 2 ? stringArray[1] : "");
            this.out.sendPacket((Buffer)bnetPacket);
            this.out.sendTextUser(string, this.out.getLocalVariable((Object)"username") + "\\" + stringArray[0] + " => " + (stringArray.length == 2 ? stringArray[1] : ""), n);
        } else if (string2.equalsIgnoreCase("w3profile")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("w3profile requires a username", string, string2);
            }
            this.requests.put(this.cookie + "", new ProfileRequest(string, stringArray[0], null, n));
            BnetPacket bnetPacket = new BnetPacket(53);
            bnetPacket.add(this.cookie);
            bnetPacket.addNTString(stringArray[0]);
            this.out.sendPacket((Buffer)bnetPacket);
            ++this.cookie;
        } else {
            this.out.sendTextUser(string, "Error in Profile plugin: unknown command.  Please report to iago.", 0);
        }
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "Get all profiles", "false").equalsIgnoreCase("true")) {
            this.out.sendPacket((Buffer)this.getRequest(null, string, this.out.getLocalSettingDefault(this.getName(), "Default keys", "profile\\sex, profile\\age, profile\\location, profile\\description").split("\\s*,\\s*"), 3));
        }
    }

    private String getClanTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) <= '\u0000') continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
    }
}

