/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Greeting;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.gui.JTextFieldNumeric;
import java.io.IOException;
import java.util.Properties;
import java.util.TimerTask;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback,
EventCallback {
    private PublicExposedFunctions out;
    private static StaticExposedFunctions staticFuncs;
    private int count = 0;
    private TimerTask task = null;

    public void load(StaticExposedFunctions staticExposedFunctions) {
        staticFuncs = staticExposedFunctions;
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "idle", 1, false, "AN", "[count|time|off]", "Sets the idle to specified type, or shows current type", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "setidle", 1, false, "AN", "[message]", "Sets the idle message.  %c = channel, %v = bot version, ", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "idlecount", 1, false, "AN", "[count]", "Sets the count or time between idles, depending on the idle type", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "greet", 1, false, "AN", "[on|off]", "Turns greeting on or off, or shows the current status", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "setgreet", 1, false, "AN", "[message]", "Sets the greet message.  %c = channel, %v = bot version, %n = username, %p = ping", null);
        if (publicExposedFunctions.getLocalSettingDefault(this.getName(), "idle", "off").equalsIgnoreCase("time")) {
            this.enableTimer();
        }
    }

    public void enableTimer() {
        this.disableTimer();
        long l = Long.parseLong(this.out.getLocalSettingDefault(this.getName(), "idle time/count", "60")) * 1000L;
        this.task = new IdleCallback();
        this.out.schedule(this.task, l);
    }

    public void disableTimer() {
        if (this.task != null) {
            this.out.unschedule(this.task);
        }
        this.task = null;
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Greeting";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "A plugin for greets and idles";
    }

    public String getLongDescription() {
        return "A plugin for annoying things like greet and idles";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("greet", "false");
        properties.setProperty("greet message", "Welcome to %c, %n! Your ping is %p.  -- %v");
        properties.setProperty("idle", "off");
        properties.setProperty("idle message", "I am annoying because I have an idle!");
        properties.setProperty("idle time/count", "60");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("greet", "Whether or not to greet users who enter the channel");
        properties.setProperty("greet message", "The message that it whispered to users when they enter the channel.  %c = channel, %n = name, %p = ping, %v = bot version");
        properties.setProperty("idle", "Whether or not to have an idle message.  Count = a message is shown ever 'x' messages in the channel, time = a message is shown every 'x' seconds");
        properties.setProperty("idle message", "The message that is said out loud when the idle time/count elapses.  %c = channel, %n = name, %p = ping, %v = bot version");
        properties.setProperty("idle time/count", "If idle is 'count', the number of messages to talk after, or if idle is 'time', the amount of time (in seconds) to wait.  Bot needs to be restarted to change time idle.");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("greet")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("idle")) {
            JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"off", "count", "time"});
            jComboBox.setSelectedItem(string2);
            return jComboBox;
        }
        if (string.equalsIgnoreCase("idle time/count")) {
            return new JTextFieldNumeric(string2);
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("idle")) {
            if (stringArray.length == 0) {
                this.out.sendTextUser(string, "Idle is currently " + this.out.getLocalSettingDefault(this.getName(), "idle", "off"), n);
            } else {
                if (!(stringArray[0].equalsIgnoreCase("off") || stringArray[0].equalsIgnoreCase("count") || stringArray[0].equalsIgnoreCase("time"))) {
                    throw new CommandUsedImproperly("Valid values: off, count, or time", string, string2);
                }
                this.out.putLocalSetting(this.getName(), "idle", stringArray[0]);
                this.out.sendText("Idle set to " + stringArray[0]);
            }
        } else if (string2.equalsIgnoreCase("setidle")) {
            if (stringArray.length == 0) {
                this.out.sendTextUser(string, "Message is currently " + this.out.getLocalSettingDefault(this.getName(), "idle message", "Idle message missing"), n);
            } else {
                this.out.putLocalSetting(this.getName(), "idle message", stringArray[0]);
                this.out.sendTextUser(string, "Idle message set to " + stringArray[0], n);
            }
        } else if (string2.equalsIgnoreCase("idlecount")) {
            if (stringArray.length == 0) {
                this.out.sendTextUser(string, "Count is currently " + this.out.getLocalSetting(this.getName(), "idle time/count") + " seconds or messages", n);
            } else {
                try {
                    this.out.putLocalSetting(this.getName(), "idle time/count", "" + Integer.parseInt(stringArray[0]));
                    this.out.sendTextUser(string, "Idle count set to " + stringArray[0], n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CommandUsedImproperly("Argument to .idlecount must be numeric", string, string2);
                }
            }
        } else if (string2.equalsIgnoreCase("greet")) {
            if (stringArray.length == 0) {
                this.out.sendTextUser(string, "Greet is " + (this.out.getLocalSettingDefault(this.getName(), "greet", "false").equalsIgnoreCase("true") ? "on" : "off"), n);
            } else {
                if (!stringArray[0].equalsIgnoreCase("on") && !stringArray[0].equalsIgnoreCase("off")) {
                    throw new CommandUsedImproperly("Valid values for greet are \"on\" or \"off\"", string, string2);
                }
                this.out.putLocalSetting(this.getName(), "greet", stringArray[0].equalsIgnoreCase("on") ? "true" : "false");
                this.out.sendTextUser(string, "Greet set to " + stringArray[0], n);
            }
        } else if (string2.equalsIgnoreCase("setgreet")) {
            if (stringArray.length == 0) {
                this.out.sendTextUser(string, "Greet message is " + this.out.getLocalSettingDefault(this.getName(), "greet message", "not set"), n);
            } else {
                this.out.putLocalSetting(this.getName(), "greet message", stringArray[0]);
                this.out.sendTextUser(string, "Greet message set to " + stringArray[0], n);
            }
        }
        String string3 = this.out.getLocalSettingDefault(this.getName(), "idle", "off");
        this.disableTimer();
        if (string3.equalsIgnoreCase("time")) {
            this.enableTimer();
        }
    }

    private void doCountIdle(String string, int n) throws PluginException, IOException {
        int n2;
        if (!this.out.getLocalSettingDefault(this.getName(), "idle", "off").equalsIgnoreCase("count")) {
            return;
        }
        try {
            n2 = Integer.parseInt(this.out.getLocalSettingDefault(this.getName(), "idle time/count", "60"));
        }
        catch (NumberFormatException numberFormatException) {
            this.out.systemMessage(5, this.getName() + "/\"idle time/count\" is set to an invalid valud -- it must be numeric");
            return;
        }
        ++this.count;
        if (this.count >= n2) {
            String string2 = this.out.getLocalSettingDefault(this.getName(), "idle message", "Missing idle message");
            this.out.sendTextPriority(this.convertString(string2, string, n), -50);
            this.count = 0;
        }
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.doCountIdle(string, n);
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.doCountIdle(string, n);
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "greet", "false").equalsIgnoreCase("true")) {
            String string3 = this.out.getLocalSetting(this.getName(), "greet message");
            this.out.sendTextUser(string, this.convertString(string3, string, n), 0);
        } else {
            this.doCountIdle(string, n);
        }
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    private String convertString(String string, String string2, int n) {
        string = string.replaceAll("%c", this.out.channelGetName());
        string = string.replaceAll("%v", "JavaOp2 " + staticFuncs.getVersion());
        if (string2 != null) {
            string = this.out.getLocalVariable((Object)"game").equals("D2DV") || this.out.getLocalVariable((Object)"game").equals("D2XP") ? string.replaceAll("%n", "*" + string2) : string.replaceAll("%n", string2);
            string = string.replaceAll("%p", n + "");
        }
        return string;
    }

    private String convertString(String string) {
        return this.convertString(string, null, 0);
    }

    private class IdleCallback
    extends TimerTask {
        @Override
        public void run() {
            try {
                String string = PluginMain.this.out.getLocalSetting(PluginMain.this.getName(), "idle message");
                PluginMain.this.out.sendTextPriority(PluginMain.this.convertString(string), -100);
            }
            catch (Exception exception) {
                PluginMain.this.out.systemMessage(4, "Error in idle callback: " + exception);
            }
        }
    }
}

