/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.vercheck;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.bnubot.util.TimeFormatter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLElementDecorator {
    private String name = null;
    private XMLElementDecorator parent = null;
    private final List<XMLElementDecorator> children = new LinkedList<XMLElementDecorator>();
    private String contents = null;
    private static XMLElementDecorator elem = null;

    public static XMLElementDecorator parse(String url) throws Exception {
        return XMLElementDecorator.parse(new InputSource(url));
    }

    public static synchronized XMLElementDecorator parse(InputSource source) throws Exception {
        elem = new XMLElementDecorator("root", null);
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(new ContentHandler(){

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
                XMLElementDecorator child = new XMLElementDecorator(name, elem);
                elem.addChild(child);
                elem = child;
            }

            public void endElement(String uri, String localName, String name) throws SAXException {
                elem = elem.getParent();
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                elem.appendContents(new String(ch, start, length));
            }

            public void startPrefixMapping(String prefix, String uri) throws SAXException {
            }

            public void endPrefixMapping(String prefix) throws SAXException {
            }

            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            }

            public void processingInstruction(String target, String data) throws SAXException {
            }

            public void setDocumentLocator(Locator locator) {
            }

            public void skippedEntity(String name) throws SAXException {
            }
        });
        xr.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException arg0) throws SAXException {
                arg0.printStackTrace();
            }

            public void fatalError(SAXParseException arg0) throws SAXException {
                arg0.printStackTrace();
            }

            public void warning(SAXParseException arg0) throws SAXException {
                arg0.printStackTrace();
            }
        });
        xr.parse(source);
        return elem;
    }

    public XMLElementDecorator(String name, XMLElementDecorator parent) {
        this.name = name;
        this.parent = parent;
    }

    public void addChild(XMLElementDecorator child) {
        this.children.add(child);
    }

    public XMLElementDecorator getChild(String name) {
        for (XMLElementDecorator child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public XMLElementDecorator[] getChildren(String name) {
        ArrayList<XMLElementDecorator> matches = new ArrayList<XMLElementDecorator>();
        for (XMLElementDecorator child : this.children) {
            if (!child.getName().equals(name)) continue;
            matches.add(child);
        }
        return matches.toArray(new XMLElementDecorator[matches.size()]);
    }

    public XMLElementDecorator getPath(String path) {
        XMLElementDecorator ed = this;
        String[] stringArray = path.split("\\/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if ((ed = ed.getChild(id)) == null) {
                return null;
            }
            ++n2;
        }
        return ed;
    }

    public String getName() {
        return this.name;
    }

    public XMLElementDecorator getParent() {
        return this.parent;
    }

    public void appendContents(String contents) {
        this.contents = this.contents == null ? contents : String.valueOf(this.contents) + contents;
    }

    public String getString() {
        return this.contents;
    }

    public Integer getInt() {
        if (this.contents == null) {
            return null;
        }
        if (this.contents.matches("[0-9]+")) {
            return Integer.parseInt(this.contents);
        }
        if (this.contents.matches("0x[a-fA-F0-9]+")) {
            return Integer.parseInt(this.contents.substring(2), 16);
        }
        throw new NumberFormatException(this.contents);
    }

    public boolean getBoolean() {
        return new Boolean(this.contents);
    }

    public Date getDate() {
        if (this.contents == null) {
            return null;
        }
        if (this.contents.matches("[0-9]+")) {
            return new Date(Long.parseLong(this.contents));
        }
        try {
            return new Date(TimeFormatter.parseDate(this.contents));
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(this.contents);
        }
    }

    public String toString() {
        String out;
        if (this.children.size() == 0) {
            out = this.contents;
        } else {
            out = "";
            for (XMLElementDecorator child : this.children) {
                out = String.valueOf(out) + "\n" + child.toString();
            }
            out = String.valueOf(out.replace("\n", "\n\t")) + "\n";
        }
        return "<" + this.name + ">" + out + "</" + this.name + ">";
    }
}

