/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.vercheck;

import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.bnubot.util.OperatingSystem;
import net.bnubot.util.Out;
import net.bnubot.util.task.TaskManager;
import net.bnubot.vercheck.ReleaseType;
import net.bnubot.vercheck.VersionCheck;

public class InstallMain {
    public static void main(String[] args) throws Exception {
        boolean gui = true;
        boolean disableLaunch = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equals("-cli")) {
                gui = false;
            } else if (arg.equals("-v") || arg.equals("-debug")) {
                Out.setDebug(true);
            } else if (arg.equals("-nolaunch")) {
                disableLaunch = true;
            } else {
                if (!(arg.equals("-h") || arg.equals("-help") || arg.equals("--help"))) {
                    System.out.println("Invalid switch");
                }
                System.out.println("Use: java -jar BNUBot-Install.jar [-cli] [-v] [-nolaunch]");
                System.out.println("\t-cli       Disable graphical interface");
                System.out.println("\t-v         Enable verbose logging");
                System.out.println("\t-nolaunch  Disable automatic launching of the bot");
                return;
            }
            ++n2;
        }
        String downloadFolder = ".";
        if (gui) {
            try {
                JFileChooser jfc = new JFileChooser();
                jfc.setFileSelectionMode(1);
                if (jfc.showDialog(null, "Install Here") != 0) {
                    System.exit(0);
                }
                downloadFolder = jfc.getSelectedFile().getAbsolutePath();
            }
            catch (Exception e) {
                Out.info(InstallMain.class, "GUI failed to initialize, disabling.");
                gui = false;
            }
        }
        String command = "java -jar \"" + downloadFolder + "/BNUBot.jar\"";
        String jarFileName = "BNUBot.jar";
        switch (OperatingSystem.userOS) {
            case OSX: {
                String appdir = "BNUBot.app";
                jarFileName = "Contents/Resources/Java/" + jarFileName;
                downloadFolder = downloadFolder == null ? appdir : String.valueOf(downloadFolder) + "/" + appdir;
                command = String.valueOf(downloadFolder) + "/Contents/MacOS/JavaApplicationStub";
                break;
            }
            case WINDOWS: {
                command = String.valueOf(downloadFolder) + "/BNUBot.exe";
            }
        }
        JFrame jf = null;
        if (gui) {
            jf = new JFrame("Installing BNU-Bot");
            Box box = new Box(1);
            jf.add(box);
            TaskManager.setTaskLocation(box);
            TaskManager.setWindow(jf);
        }
        if (!VersionCheck.checkVersion(true, ReleaseType.Stable, jarFileName, downloadFolder)) {
            try {
                JOptionPane.showMessageDialog(null, "Install failed!", "Error", 0);
            }
            catch (Exception e) {
                Out.error(InstallMain.class, "Install failed");
            }
            System.exit(1);
        }
        if (jf != null) {
            jf.dispose();
        }
        Runtime rt = Runtime.getRuntime();
        if (command.endsWith("/JavaApplicationStub")) {
            String cmd_chmod = "chmod 755 " + command;
            Out.info(InstallMain.class, "Fixing JavaApplicationStub: " + cmd_chmod);
            int ret = rt.exec(cmd_chmod).waitFor();
            if (ret != 0) {
                throw new IllegalStateException("Failed to execute command [ " + cmd_chmod + " ] error code: " + ret);
            }
        }
        if (disableLaunch) {
            Out.info(InstallMain.class, "Install succeeded");
            System.exit(0);
        }
        if (gui) {
            try {
                int opt = JOptionPane.showConfirmDialog(null, "Install complete. Launch BNU-Bot?", "Installer", 0);
                if (opt == 1) {
                    System.exit(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Out.info(InstallMain.class, "Launching: " + command);
        rt.exec(command);
        System.exit(0);
    }
}

