/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import net.bnubot.util.OperatingSystem;
import net.bnubot.util.task.Task;
import net.bnubot.util.task.TaskManager;

public class TaskGui
extends Task {
    private static final long serialVersionUID = -5561830539661899515L;
    private final Box box;
    private final JProgressBar pb;
    private final JLabel jl;
    private int count = 0;
    private int max;
    private String units;
    private final String title;
    private boolean complete = false;

    protected TaskGui(String title, int max, String units) {
        this.max = max;
        this.units = units;
        this.title = title;
        this.pb = new JProgressBar(0, max);
        this.pb.setString(title);
        this.pb.setStringPainted(true);
        this.pb.setIndeterminate(max == 0);
        Dimension d = new Dimension(379, 24);
        this.pb.setPreferredSize(d);
        switch (OperatingSystem.userOS) {
            case OSX: {
                this.box = new Box(1);
                this.jl = new JLabel(title);
                this.box.add(this.jl);
                this.box.add(this.pb);
                this.box.setBackground(Color.WHITE);
                this.jl.setForeground(Color.BLACK);
                break;
            }
            default: {
                this.box = null;
                this.jl = null;
            }
        }
    }

    public void setIndeterminate() {
        this.pb.setIndeterminate(true);
        this.max = 0;
        this.units = null;
    }

    public void setDeterminate(int length, String units) {
        this.pb.setIndeterminate(false);
        this.pb.setMaximum(length);
        this.pb.setValue(0);
        this.max = length;
        this.units = units;
    }

    protected Component getComponent() {
        if (this.box != null) {
            return this.box;
        }
        return this.pb;
    }

    protected boolean isDeterminant() {
        return this.max != 0;
    }

    public void updateProgress(String currentStep) {
        if (this.complete) {
            this.setString("Complete");
        } else {
            StringBuilder s = new StringBuilder();
            if (this.isDeterminant()) {
                int percentComplete = (int)((double)this.count * 100.0 / (double)this.max);
                s.append(String.valueOf(percentComplete)).append(" % ");
                if (this.units != null) {
                    s.append("(");
                    s.append(this.count).append("/");
                    s.append(this.max).append(" ");
                    s.append(this.units).append(") ");
                }
            }
            if (currentStep != null) {
                s.append(currentStep);
            }
            this.setString(s.toString());
        }
    }

    private void setString(String s) {
        if (this.jl == null) {
            s = String.valueOf(this.title) + ": " + s;
            if (!s.equals(this.pb.getString())) {
                this.pb.setString(s);
            }
        } else if (!s.equals(this.jl.getText())) {
            this.jl.setText(s);
        }
    }

    public void advanceProgress() {
        this.setProgress(++this.count);
    }

    public void setProgress(int step) {
        this.setProgress(step, null);
    }

    public void setProgress(int step, String currentStep) {
        this.count = step;
        this.updateProgress(currentStep);
        if (this.count >= this.max) {
            this.pb.setValue(this.max);
            this.complete();
        } else {
            this.pb.setValue(this.count);
        }
    }

    public void complete() {
        this.complete = true;
        TaskManager.complete(this);
    }
}

