/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeFormatter {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static TimeZone timeZone = TimeZone.getDefault();
    public static String tsFormat = "%1$tH:%1$tM:%1$tS.%1$tL";
    private static DateFormat df = DateFormat.getDateInstance();
    private static DateFormat dtf = DateFormat.getDateTimeInstance();

    public static String getTimestamp() {
        try {
            return String.format(tsFormat, Calendar.getInstance(timeZone));
        }
        catch (NoSuchMethodError e) {
            return "";
        }
    }

    public static String formatTime(long time) {
        return TimeFormatter.formatTime(time, true);
    }

    public static String formatTime(long time, boolean ms) {
        if (time < 0L) {
            return "(neg) " + TimeFormatter.formatTime(time * -1L, ms);
        }
        if (time == 0L) {
            return ms ? "0ms" : "0s";
        }
        String text = "";
        if (ms) {
            if (time < 60000L) {
                text = String.valueOf(Long.toString(time % 1000L)) + "ms";
            }
            time /= 1000L;
        } else {
            --time;
            time /= 1000L;
            ++time;
        }
        if (time > 0L) {
            if (time < 3600L) {
                text = String.valueOf(Long.toString(time % 60L)) + "s " + text;
            }
            if ((time /= 60L) > 0L) {
                if (time < 1440L) {
                    text = String.valueOf(Long.toString(time % 60L)) + "m " + text;
                }
                if ((time /= 60L) > 0L) {
                    if (time < 168L) {
                        text = String.valueOf(Long.toString(time % 24L)) + "h " + text;
                    }
                    if ((time /= 24L) > 0L) {
                        text = String.valueOf(Long.toString(time)) + "d " + text;
                    }
                }
            }
        }
        return text.trim();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long parseDuration(String duration) throws NumberFormatException {
        long out = 0L;
        String[] stringArray = duration.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                String part = stringArray[n2];
                if (part.length() != 0) {
                    int i = 0;
                    while (i < part.length()) {
                        char c = part.charAt(i);
                        if (c < '0' || c > '9') break;
                        ++i;
                    }
                    long base = Long.parseLong(part.substring(0, i));
                    String unit = part.substring(i).toLowerCase();
                    switch (unit.charAt(0)) {
                        case 's': {
                            if (!"s".equals(unit) && !"second".equals(unit) && !"seconds".equals(unit)) break;
                            out += base * 1000L;
                            break block10;
                        }
                        case 'm': {
                            if (!"m".equals(unit) && !"min".equals(unit) && !"mins".equals(unit) && !"minute".equals(unit) && !"minutes".equals(unit)) break;
                            out += base * 60000L;
                            break block10;
                        }
                        case 'h': {
                            if (!"h".equals(unit) && !"hour".equals(unit) && !"hours".equals(unit)) break;
                            out += base * 3600000L;
                            break block10;
                        }
                        case 'd': {
                            if (!"d".equals(unit) && !"day".equals(unit) && !"days".equals(unit)) break;
                            out += base * 86400000L;
                            break block10;
                        }
                        case 'w': {
                            if (!"w".equals(unit) && !"week".equals(unit) && !"weeks".equals(unit)) break;
                            out += base * 604800000L;
                            break block10;
                        }
                    }
                    throw new NumberFormatException("Invalid unit: " + unit);
                }
            }
            ++n2;
        }
        return out;
    }

    public static Date fileTime(long ft) {
        long date = ft / 10000L - 11644455600000L;
        date += (long)timeZone.getOffset(date);
        return new Date(date);
    }

    public static long parseDate(String d) throws ParseException {
        df.setCalendar(Calendar.getInstance(timeZone));
        return df.parse(d).getTime();
    }

    public static String formatDate(Date d) {
        df.setCalendar(Calendar.getInstance(timeZone));
        return df.format(d);
    }

    public static long parseDateTime(String dt) throws ParseException {
        dtf.setCalendar(Calendar.getInstance(timeZone));
        return dtf.parse(dt).getTime();
    }

    public static String formatDateTime(Date d) {
        dtf.setCalendar(Calendar.getInstance(timeZone));
        return dtf.format(d);
    }
}

