/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.settings;

import java.util.TimeZone;
import net.bnubot.settings.Settings;
import net.bnubot.util.Out;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsSection {
    private final String header;

    public SettingsSection(String header) {
        this.header = header;
    }

    private String getKey(String setting) {
        if (this.header == null) {
            return "general_" + setting;
        }
        return String.valueOf(this.header) + "_" + setting;
    }

    public String read(String setting, String defaultValue) {
        return Settings.read(this.getKey(setting), defaultValue);
    }

    public boolean read(String setting, boolean defaultValue) {
        return Boolean.parseBoolean(this.read(setting, Boolean.toString(defaultValue)));
    }

    public int read(String setting, int defaultValue) {
        return Integer.parseInt(this.read(setting, Integer.toString(defaultValue)));
    }

    public long read(String setting, long defaultValue) {
        return Long.parseLong(this.read(setting, Long.toString(defaultValue)));
    }

    public TimeZone read(String setting, TimeZone defaultValue) {
        return TimeZone.getTimeZone(this.read(setting, defaultValue.getID()));
    }

    public <T extends Enum<T>> T read(String setting, T defaultValue) {
        String readValue = this.read(setting, defaultValue.name());
        try {
            return Enum.valueOf(defaultValue.getDeclaringClass(), readValue);
        }
        catch (Exception e) {
            Out.error(Settings.class, "Invalid " + defaultValue.getDeclaringClass().getSimpleName() + ": " + readValue);
            return defaultValue;
        }
    }

    public void write(String setting, String value) {
        Settings.write(this.getKey(setting), value);
    }

    public void write(String setting, boolean value) {
        this.write(setting, Boolean.toString(value));
    }

    public void write(String setting, int value) {
        this.write(setting, Integer.toString(value));
    }

    public void write(String setting, long value) {
        this.write(setting, Long.toString(value));
    }

    public void write(String setting, TimeZone value) {
        this.write(setting, value.getID());
    }

    public <T extends Enum<T>> void write(String setting, T value) {
        this.write(setting, value.name());
    }
}

