/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.bnubot.settings.SettingsSection;
import net.bnubot.util.Out;
import net.bnubot.util.SortedProperties;
import net.bnubot.vercheck.CurrentVersion;

public class Settings {
    public static final File keysFile = new File(String.valueOf(Settings.getRootPath()) + "cdkeys.txt");
    private static final File propsFile = new File(String.valueOf(Settings.getRootPath()) + "settings.ini");
    private static final Properties props = new SortedProperties();
    private static boolean anythingChanged = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File file = propsFile;
        synchronized (file) {
            if (propsFile.exists()) {
                try {
                    props.load(new FileInputStream(propsFile));
                }
                catch (Exception e) {
                    Out.exception(e);
                }
            }
        }
    }

    public static SettingsSection getSection(String header) {
        return new SettingsSection(header);
    }

    public static String getRootPath() {
        String out = System.getProperty("net.bnubot.rootpath");
        if (out != null) {
            return out;
        }
        return "";
    }

    protected static String read(String key, String defaultValue) {
        if (props.containsKey(key)) {
            return props.getProperty(key);
        }
        Settings.write(key, defaultValue);
        return defaultValue;
    }

    protected static void write(String key, String value) {
        if (value == null) {
            value = new String();
        }
        if (props.containsKey(key) && props.getProperty(key).equals(value)) {
            return;
        }
        anythingChanged = true;
        if (Out.isDebug(Settings.class)) {
            Out.debugAlways(Settings.class, "setting " + key + "=" + value);
        }
        props.setProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() {
        if (!anythingChanged) {
            return;
        }
        Out.debug(Settings.class, "Writing settings.ini");
        try {
            String comment = CurrentVersion.version().toString();
            File file = propsFile;
            synchronized (file) {
                props.store(new FileOutputStream(propsFile), comment);
            }
            anythingChanged = false;
        }
        catch (Exception e) {
            Out.fatalException(e);
        }
    }
}

