/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.vercheck;

import java.util.Date;
import net.bnubot.vercheck.ReleaseType;

public class VersionNumber {
    private ReleaseType RELEASE_TYPE = null;
    private Integer VER_MAJOR = null;
    private Integer VER_MINOR = null;
    private Integer VER_REVISION = null;
    private Integer VER_RELEASE = null;
    private Integer VER_SVN_REVISION = null;
    private String VER_STRING = null;
    private Date BUILD_DATE = null;

    public VersionNumber(ReleaseType rt, Integer major, Integer minor, Integer revision, Integer release) {
        this.RELEASE_TYPE = rt;
        this.VER_MAJOR = major;
        this.VER_MINOR = minor;
        this.VER_REVISION = revision;
        this.VER_RELEASE = release;
    }

    public VersionNumber(ReleaseType rt, Integer major, Integer minor, Integer revision, Integer release, Integer svn, Date builddate) {
        this(rt, major, minor, revision, release);
        this.VER_SVN_REVISION = svn;
        this.BUILD_DATE = builddate;
    }

    public String toString() {
        if (this.VER_STRING != null) {
            return this.VER_STRING;
        }
        this.VER_STRING = String.valueOf(this.VER_MAJOR.toString()) + '.' + this.VER_MINOR.toString() + '.' + this.VER_REVISION.toString();
        if (this.VER_RELEASE != null && this.VER_RELEASE != 0) {
            this.VER_STRING = String.valueOf(this.VER_STRING) + " Release " + this.VER_RELEASE.toString();
        }
        if (this.RELEASE_TYPE.isDevelopment()) {
            this.VER_STRING = String.valueOf(this.VER_STRING) + " Development";
        } else if (this.RELEASE_TYPE.isAlpha()) {
            this.VER_STRING = String.valueOf(this.VER_STRING) + " Alpha";
        } else if (this.RELEASE_TYPE.isBeta()) {
            this.VER_STRING = String.valueOf(this.VER_STRING) + " Beta";
        } else if (this.RELEASE_TYPE.isReleaseCandidate()) {
            this.VER_STRING = String.valueOf(this.VER_STRING) + " RC";
        }
        if (this.VER_SVN_REVISION != null) {
            this.VER_STRING = String.valueOf(this.VER_STRING) + " (r" + this.VER_SVN_REVISION.toString() + ")";
        }
        return this.VER_STRING;
    }

    public Date getBuildDate() {
        return this.BUILD_DATE;
    }

    public void setBuildDate(Date buildDate) {
        this.BUILD_DATE = buildDate;
    }

    public boolean isNewerThan(VersionNumber vn) {
        return this.compareTo(vn) > 0;
    }

    public int compareTo(VersionNumber vn) {
        if (this.VER_SVN_REVISION != null && vn.VER_SVN_REVISION != null) {
            return this.VER_SVN_REVISION.compareTo(vn.VER_SVN_REVISION);
        }
        if (this.VER_MAJOR > vn.VER_MAJOR) {
            return 1;
        }
        if (this.VER_MAJOR < vn.VER_MAJOR) {
            return -1;
        }
        if (this.VER_MINOR > vn.VER_MINOR) {
            return 1;
        }
        if (this.VER_MINOR < vn.VER_MINOR) {
            return -1;
        }
        if (this.VER_REVISION > vn.VER_REVISION) {
            return 1;
        }
        if (this.VER_REVISION < vn.VER_REVISION) {
            return -1;
        }
        if (this.VER_RELEASE > vn.VER_RELEASE) {
            return 1;
        }
        if (this.VER_RELEASE < vn.VER_RELEASE) {
            return -1;
        }
        if (vn.RELEASE_TYPE.isStable() ^ !this.RELEASE_TYPE.isStable()) {
            return this.RELEASE_TYPE.isStable() ? 1 : -1;
        }
        if (vn.RELEASE_TYPE.isReleaseCandidate() ^ !this.RELEASE_TYPE.isReleaseCandidate()) {
            return this.RELEASE_TYPE.isReleaseCandidate() ? 1 : -1;
        }
        if (vn.RELEASE_TYPE.isBeta() ^ !this.RELEASE_TYPE.isBeta()) {
            return this.RELEASE_TYPE.isBeta() ? 1 : -1;
        }
        if (vn.RELEASE_TYPE.isAlpha() ^ !this.RELEASE_TYPE.isAlpha()) {
            return this.RELEASE_TYPE.isAlpha() ? 1 : -1;
        }
        if (vn.RELEASE_TYPE.isDevelopment() ^ !this.RELEASE_TYPE.isDevelopment()) {
            return this.RELEASE_TYPE.isDevelopment() ? 1 : -1;
        }
        return 0;
    }

    public ReleaseType getReleaseType() {
        return this.RELEASE_TYPE;
    }

    public void setReleaseType(ReleaseType releaseType) {
        this.RELEASE_TYPE = releaseType;
        this.VER_STRING = null;
    }

    public Integer revision() {
        return this.VER_SVN_REVISION;
    }

    public Integer getMajor() {
        return this.VER_MAJOR;
    }

    public void setMajor(Integer major) {
        this.VER_MAJOR = major;
        this.VER_STRING = null;
    }

    public Integer getMinor() {
        return this.VER_MINOR;
    }

    public void setMinor(Integer minor) {
        this.VER_MINOR = minor;
        this.VER_STRING = null;
    }

    public Integer getRevision() {
        return this.VER_REVISION;
    }

    public void setRevision(Integer revision) {
        this.VER_REVISION = revision;
        this.VER_STRING = null;
    }

    public Integer getRelease() {
        return this.VER_RELEASE;
    }

    public void setRelease(Integer release) {
        this.VER_RELEASE = release;
        this.VER_STRING = null;
    }
}

