/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.vercheck;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.swing.JOptionPane;
import net.bnubot.settings.GlobalSettings;
import net.bnubot.util.OperatingSystem;
import net.bnubot.util.Out;
import net.bnubot.util.SHA1Sum;
import net.bnubot.util.URLDownloader;
import net.bnubot.vercheck.CurrentVersion;
import net.bnubot.vercheck.ReleaseType;
import net.bnubot.vercheck.VersionNumber;
import net.bnubot.vercheck.XMLElementDecorator;
import org.jbls.util.Constants;

public class VersionCheck {
    protected static XMLElementDecorator elem = null;
    protected static VersionNumber vnLatest = null;

    public static boolean checkVersion() throws Exception {
        return VersionCheck.checkVersion(false, GlobalSettings.releaseType);
    }

    public static boolean checkVersion(boolean forceDownload, ReleaseType rt) throws Exception {
        if (CurrentVersion.fromJar()) {
            String path = System.getProperty("net.bnubot.jarpath", "BNUBot.jar");
            if (!new File(path).exists()) {
                throw new FileNotFoundException(path);
            }
            return VersionCheck.checkVersion(forceDownload, rt, path, null);
        }
        return VersionCheck.checkVersion(false, rt, null, null);
    }

    public static boolean checkVersion(boolean forceDownload, ReleaseType rt, String jarFileName, String downloadFolder) throws Exception {
        boolean cv = VersionCheck.doCheckVersion(forceDownload, rt, jarFileName, downloadFolder);
        URLDownloader.flush();
        if (!cv) {
            Out.debug(VersionCheck.class, "No update available.");
        }
        return cv;
    }

    public static boolean doCheckVersion(boolean forceDownload, ReleaseType rt, String jarFileName, String downloadFolder) throws Exception {
        XMLElementDecorator verLatest;
        XMLElementDecorator gamesElem;
        XMLElementDecorator downloads;
        XMLElementDecorator error;
        try {
            String url = "http://www.clanbnu.net/bnubot/version.php?";
            if (!forceDownload && CurrentVersion.version().revision() != null) {
                url = String.valueOf(url) + "svn=" + CurrentVersion.version().revision() + "&";
            }
            url = String.valueOf(url) + "release=" + rt.toString();
            url = String.valueOf(url) + "&os=" + OperatingSystem.userOS.name();
            Out.debug(VersionCheck.class, "Requesting latest version from " + url);
            elem = XMLElementDecorator.parse(url);
        }
        catch (Exception e) {
            Out.error(VersionCheck.class, "Failed to get latest version: " + e.getClass().getSimpleName() + ".");
            return false;
        }
        if (downloadFolder != null) {
            jarFileName = String.valueOf(downloadFolder) + "/" + jarFileName;
        }
        if ((error = elem.getChild("error")) != null) {
            Out.error(VersionCheck.class, error.getString());
            return false;
        }
        XMLElementDecorator motd = elem.getPath("bnubot/motd");
        if (motd != null && motd.getString() != null) {
            Out.info(VersionCheck.class, motd.getString());
        }
        if ((forceDownload || CurrentVersion.fromJar()) && (downloads = elem.getPath("bnubot/downloads")) != null) {
            XMLElementDecorator[] xMLElementDecoratorArray = downloads.getChildren("file");
            int n = xMLElementDecoratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLElementDecorator file = xMLElementDecoratorArray[n2];
                XMLElementDecorator sha1Element = file.getChild("sha1");
                SHA1Sum sha1 = null;
                if (sha1Element != null) {
                    sha1 = new SHA1Sum(sha1Element.getString());
                }
                String from = file.getChild("from").getString();
                String to = file.getChild("to").getString();
                if (downloadFolder != null) {
                    to = String.valueOf(downloadFolder) + "/" + to;
                }
                URLDownloader.downloadURL(new URL(from), new File(to), sha1, false);
                ++n2;
            }
        }
        if ((gamesElem = elem.getPath("bnubot/games")) != null) {
            int i = 0;
            while (i < Constants.prods.length) {
                int vb;
                String game = Constants.prods[i];
                int verByte = Constants.IX86verbytes[i];
                XMLElementDecorator gameElem = gamesElem.getPath(game);
                if (gameElem != null && verByte != (vb = gameElem.getPath("verbyte").getInt().intValue())) {
                    Out.error(VersionCheck.class, "Verbyte for game " + game + " is updating from 0x" + Integer.toHexString(verByte) + " to 0x" + Integer.toHexString(vb));
                    Constants.IX86verbytes[i] = vb;
                }
                ++i;
            }
        }
        if ((verLatest = elem.getPath("bnubot/latestVersion")) == null) {
            return false;
        }
        vnLatest = new VersionNumber(Enum.valueOf(ReleaseType.class, verLatest.getChild("type").getString()), verLatest.getChild("major").getInt(), verLatest.getChild("minor").getInt(), verLatest.getChild("revision").getInt(), verLatest.getChild("release").getInt(), verLatest.getChild("svn").getInt(), verLatest.getChild("built").getDate());
        String url = verLatest.getChild("url").getString();
        XMLElementDecorator sha1Element = verLatest.getChild("sha1");
        SHA1Sum sha1 = null;
        if (sha1Element != null && sha1Element.getString() != null) {
            sha1 = new SHA1Sum(sha1Element.getString());
        }
        if (forceDownload) {
            if (url == null) {
                return false;
            }
            URLDownloader.downloadURL(new URL(url), new File(jarFileName), sha1, true);
            return true;
        }
        if (!vnLatest.isNewerThan(CurrentVersion.version())) {
            return false;
        }
        Out.error(VersionCheck.class, "Latest version: " + vnLatest.toString());
        if (url == null) {
            return true;
        }
        try {
            File thisJar;
            if (jarFileName != null && (thisJar = new File(jarFileName)).exists()) {
                String msg = "BNU-Bot version " + vnLatest.toString() + " is available.\nWould you like to update?";
                if (JOptionPane.showConfirmDialog(null, msg, "BNU-Bot update available", 0, 3) == 0) {
                    URLDownloader.downloadURL(new URL(url), thisJar, sha1, true);
                    URLDownloader.flush();
                    JOptionPane.showMessageDialog(null, "Update complete. Please restart BNU-Bot.");
                    System.exit(0);
                }
                return true;
            }
        }
        catch (Exception e) {
            Out.exception(e);
        }
        Out.error(VersionCheck.class, "Update: " + url);
        return true;
    }
}

