/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.vercheck;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.bnubot.util.OperatingSystem;
import net.bnubot.util.Out;
import net.bnubot.vercheck.ReleaseType;
import net.bnubot.vercheck.VersionCheck;

public class InstallMain {
    public static void main(String[] args) throws Exception {
        String downloadFolder = null;
        try {
            JFileChooser jfc = new JFileChooser();
            jfc.setFileSelectionMode(1);
            if (jfc.showDialog(null, "Install Here") != 0) {
                System.exit(0);
            }
            downloadFolder = jfc.getSelectedFile().getAbsolutePath();
        }
        catch (Exception exception) {}
        Out.setDebug(true);
        String command = "java -jar \"" + downloadFolder + "/BNUBot.jar\"";
        String jarFileName = "BNUBot.jar";
        switch (OperatingSystem.userOS) {
            case OSX: {
                String appdir = "BNUBot.app";
                jarFileName = "Contents/Resources/Java/" + jarFileName;
                downloadFolder = downloadFolder == null ? appdir : String.valueOf(downloadFolder) + "/" + appdir;
                command = String.valueOf(downloadFolder) + "/Contents/MacOS/JavaApplicationStub";
                break;
            }
            case WINDOWS: {
                command = String.valueOf(downloadFolder) + "/BNUBot.exe";
            }
        }
        if (!VersionCheck.checkVersion(true, ReleaseType.Stable, jarFileName, downloadFolder)) {
            try {
                JOptionPane.showMessageDialog(null, "Install failed!", "Error", 0);
            }
            catch (Exception exception) {}
            System.exit(1);
        }
        Runtime rt = Runtime.getRuntime();
        if (command.endsWith("/JavaApplicationStub")) {
            String cmd_chmod = "chmod 755 " + command;
            Out.info(InstallMain.class, "Fixing JavaApplicationStub: " + cmd_chmod);
            int ret = rt.exec(cmd_chmod).waitFor();
            if (ret != 0) {
                throw new IllegalStateException(Integer.toString(ret));
            }
        }
        try {
            int opt = JOptionPane.showConfirmDialog(null, "Install complete. Launch BNU-Bot?", "Installer", 0);
            if (opt == 1) {
                System.exit(0);
            }
        }
        catch (Exception exception) {}
        Out.info(InstallMain.class, "Launching: " + command);
        rt.exec(command);
        System.exit(0);
    }
}

