/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util.task;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Box;
import net.bnubot.bot.gui.WindowPosition;
import net.bnubot.settings.GlobalSettings;
import net.bnubot.util.task.Task;
import net.bnubot.util.task.TaskGui;

public class TaskManager
extends Dialog {
    private static final long serialVersionUID = 641763656953338296L;
    private static Box box = null;
    private static TaskManager tm = null;

    private TaskManager(Frame owner) {
        super(owner);
    }

    public static Task createTask(String title) {
        return TaskManager.createTask(title, 0, null);
    }

    public static Task createTask(String title, String currentStep) {
        Task t = TaskManager.createTask(title);
        t.updateProgress(currentStep);
        return t;
    }

    public static Task createTask(String title, int max, String units) {
        boolean enableGUI;
        Frame owner = null;
        try {
            enableGUI = GlobalSettings.enableGUI;
            if (enableGUI) {
                owner = (Frame)Class.forName("net.bnubot.bot.gui.GuiDesktop").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            enableGUI = true;
            owner = new Frame();
        }
        if (enableGUI && tm == null) {
            tm = new TaskManager(owner);
            try {
                WindowPosition.load((Window)tm);
            }
            catch (Throwable throwable) {}
            tm.setTitle("Running Tasks");
            box = new Box(1);
            tm.add(box);
            tm.setResizable(false);
        }
        if (tm == null) {
            return new Task();
        }
        TaskGui t = new TaskGui(title, max, units);
        box.add(t.getComponent());
        tm.pack();
        tm.setVisible(true);
        return t;
    }

    protected static void complete(TaskGui t) {
        if (tm != null) {
            box.remove(t.getComponent());
            if (box.getComponentCount() == 0) {
                tm.setVisible(false);
                tm.dispose();
                tm = null;
            } else {
                tm.pack();
            }
        }
    }
}

