/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import net.bnubot.util.task.Task;
import net.bnubot.util.task.TaskManager;

public class TaskGui
extends Task {
    private static final long serialVersionUID = -5561830539661899515L;
    private final Box box;
    private final JProgressBar pb;
    private final JLabel jl;
    private int count = 0;
    private final int max;
    private final String units;
    private final String title;
    private boolean complete = false;

    protected TaskGui(String title, int max, String units) {
        this.max = max;
        this.units = units;
        this.title = title;
        this.pb = new JProgressBar(0, max);
        this.pb.setString(title);
        this.pb.setStringPainted(true);
        this.pb.setIndeterminate(max == 0);
        Dimension d = new Dimension(379, 24);
        this.pb.setPreferredSize(d);
        this.box = new Box(1);
        this.jl = new JLabel(title);
        this.box.add(this.jl);
        this.box.add(this.pb);
        this.box.setBackground(Color.WHITE);
        this.jl.setForeground(Color.BLACK);
    }

    protected Component getComponent() {
        return this.box;
    }

    protected boolean isDeterminant() {
        return this.max != 0;
    }

    public void updateProgress(String currentStep) {
        if (this.complete) {
            this.setString(String.valueOf(this.title) + " Complete");
        } else {
            String s = this.title;
            if (this.isDeterminant()) {
                int percentComplete = (int)((double)this.count * 100.0 / (double)this.max);
                s = String.valueOf(s) + " " + String.valueOf(percentComplete) + " %";
                if (this.units != null) {
                    s = String.valueOf(s) + " (";
                    s = String.valueOf(s) + String.valueOf(this.count);
                    s = String.valueOf(s) + "/";
                    s = String.valueOf(s) + String.valueOf(this.max) + " " + this.units;
                    s = String.valueOf(s) + ")";
                }
            }
            if (currentStep != null) {
                s = String.valueOf(s) + " (" + currentStep + ")";
            }
            this.setString(s);
        }
    }

    private void setString(String s) {
        if (!s.equals(this.jl.getText())) {
            this.jl.setText(s);
        }
    }

    public void advanceProgress() {
        this.setProgress(++this.count);
    }

    public void setProgress(int step) {
        this.count = step;
        this.updateProgress(null);
        if (this.count >= this.max) {
            this.pb.setValue(this.max);
            this.complete();
        } else {
            this.pb.setValue(this.count);
        }
    }

    public void complete() {
        this.complete = true;
        TaskManager.complete(this);
    }
}

