/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import net.bnubot.util.Out;
import net.bnubot.util.SHA1Sum;
import net.bnubot.util.task.Task;
import net.bnubot.util.task.TaskManager;

public class URLDownloader {
    public static List<FileDownload> queue = new LinkedList<FileDownload>();

    public static void downloadURL(URL url, File to, SHA1Sum sha1, boolean force) throws Exception {
        if (to.exists()) {
            if (sha1 == null) {
                if (!force) {
                    return;
                }
            } else {
                SHA1Sum fSHA1 = new SHA1Sum(to);
                if (fSHA1.equals(sha1)) {
                    Out.debug(URLDownloader.class, "SHA1 match for " + to.getName());
                    return;
                }
                Out.error(URLDownloader.class, "SHA1 mismatch for " + to.getName() + "\nExpected: " + sha1 + "\nCalculated: " + fSHA1);
            }
        }
        queue.add(new FileDownload(url, to, sha1, force));
    }

    public static void flush() throws Exception {
        int num = queue.size();
        if (num <= 0) {
            return;
        }
        Task t = TaskManager.createTask("Download", num, "files");
        for (FileDownload fd : queue) {
            URLDownloader.downloadURLNow(fd.url, fd.to, fd.sha1, fd.force);
            t.advanceProgress();
        }
        t.complete();
        queue.clear();
    }

    public static void downloadURLNow(URL url, File to, SHA1Sum sha1, boolean force) throws Exception {
        int c;
        String sep = System.getProperty("file.separator");
        String folders = to.getPath();
        String path = "";
        int i = 0;
        while (i < folders.length()) {
            if ((path = String.valueOf(path) + folders.charAt(i)).endsWith(sep)) {
                File f = new File(path);
                if (!f.exists()) {
                    f.mkdir();
                }
                if (!f.isDirectory()) {
                    Out.error(URLDownloader.class, String.valueOf(path) + " is not a directory!");
                    return;
                }
            }
            ++i;
        }
        Out.info(URLDownloader.class, "Downloading " + url.toExternalForm());
        URLConnection uc = url.openConnection();
        DataInputStream is = new DataInputStream(new BufferedInputStream(uc.getInputStream()));
        FileOutputStream os = new FileOutputStream(to);
        byte[] b = new byte[1024];
        int fileLength = uc.getHeaderFieldInt("Content-Length", 0) / b.length;
        Task task = null;
        if (fileLength > 0) {
            task = TaskManager.createTask(url.toExternalForm(), fileLength, "kB");
        }
        while ((c = is.read(b)) != -1) {
            os.write(b, 0, c);
            if (task == null) continue;
            task.advanceProgress();
        }
        if (task != null) {
            task.complete();
        }
        os.close();
        is.close();
    }

    private static class FileDownload {
        URL url;
        File to;
        SHA1Sum sha1;
        boolean force;

        public FileDownload(URL url, File to, SHA1Sum sha1, boolean force) {
            this.url = url;
            this.to = to;
            this.sha1 = sha1;
            this.force = force;
        }
    }
}

