/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeFormatter {
    public static String tsFormat = "%1$tH:%1$tM:%1$tS.%1$tL";
    private static DateFormat df = DateFormat.getDateInstance();
    private static DateFormat dtf = DateFormat.getDateTimeInstance();

    public static String getTimestamp() {
        return String.format(tsFormat, Calendar.getInstance());
    }

    public static String formatTime(long time) {
        return TimeFormatter.formatTime(time, true);
    }

    public static String formatTime(long time, boolean ms) {
        if (time < 0L) {
            throw new IllegalArgumentException("formatTime does not format negative numbers");
        }
        if (time == 0L) {
            return ms ? "0ms" : "0s";
        }
        String text = "";
        if (ms) {
            if (time < 60000L) {
                text = String.valueOf(Long.toString(time % 1000L)) + "ms";
            }
            time /= 1000L;
        } else {
            --time;
            time /= 1000L;
            ++time;
        }
        if (time > 0L) {
            if (time < 3600L) {
                text = String.valueOf(Long.toString(time % 60L)) + "s " + text;
            }
            if ((time /= 60L) > 0L) {
                if (time < 1440L) {
                    text = String.valueOf(Long.toString(time % 60L)) + "m " + text;
                }
                if ((time /= 60L) > 0L) {
                    if (time < 168L) {
                        text = String.valueOf(Long.toString(time % 24L)) + "h " + text;
                    }
                    if ((time /= 24L) > 0L) {
                        text = String.valueOf(Long.toString(time)) + "d " + text;
                    }
                }
            }
        }
        return text.trim();
    }

    public static Date fileTime(long ft) {
        long date = ft / 10000L - 11644455600000L;
        date += (long)TimeZone.getDefault().getOffset(date);
        return new Date(date);
    }

    public static long parseDate(String d) throws ParseException {
        return df.parse(d).getTime();
    }

    public static String formatDate(Date d) {
        return df.format(d);
    }

    public static long parseDateTime(String dt) throws ParseException {
        return dtf.parse(dt).getTime();
    }

    public static String formatDateTime(Date d) {
        return dtf.format(d);
    }
}

