/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.JOptionPane;
import net.bnubot.bot.gui.GuiDesktop;
import net.bnubot.core.Connection;
import net.bnubot.settings.GlobalSettings;
import net.bnubot.settings.Settings;
import net.bnubot.util.SortedProperties;
import net.bnubot.util.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Out {
    private static PrintStream outStream = System.out;
    private static final ThreadLocal<Connection> outConnection = new ThreadLocal();
    private static Connection outConnectionDefault = null;
    private static boolean globalDebug = Settings.read(null, "debug", false);
    private static boolean debugToGui = Settings.read(null, "debugToGui", true);
    private static final Properties debug = new SortedProperties();
    private static final File debugFile = new File("debug.properties");

    static {
        try {
            if (debugFile.exists()) {
                debug.load(new FileInputStream(debugFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getRelevantStack(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String[] lines = sw.toString().trim().split("\n");
        String out = lines[0];
        boolean ellipsis = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).startsWith("at net.bnubot.") || line.startsWith("Caused by:")) {
                out = String.valueOf(out) + "\n" + line;
                ellipsis = false;
            } else if (!ellipsis) {
                ellipsis = true;
                out = String.valueOf(out) + "\n...";
            }
            ++n2;
        }
        return out;
    }

    private static Connection getOutConnection() {
        Connection oc = outConnection.get();
        if (oc != null) {
            return oc;
        }
        return outConnectionDefault;
    }

    public static void exception(Exception e) {
        Connection oc = Out.getOutConnection();
        if (oc != null) {
            Out.error(e.getClass(), Out.getRelevantStack(e));
        }
        if (outStream != null) {
            e.printStackTrace(outStream);
        } else {
            e.printStackTrace();
        }
    }

    public static void fatalException(Exception e) {
        try {
            JOptionPane.showMessageDialog(null, Out.getRelevantStack(e), e.getClass().getSimpleName(), 0);
        }
        catch (Exception exception) {}
        e.printStackTrace();
        System.exit(1);
    }

    public static void error(Class<?> source, String text) {
        Connection oc = Out.getOutConnection();
        if (oc != null) {
            oc.recieveError("(" + source.getSimpleName() + ") " + text);
        } else if (outStream != null) {
            outStream.println("[" + TimeFormatter.getTimestamp() + "] (" + source.getSimpleName() + ") ERROR " + text);
        }
    }

    public static void debug(Class<?> source, String text) {
        if (Out.isDebug(source)) {
            Out.debugAlways(source, text);
        }
    }

    public static void debugAlways(Class<?> source, String text) {
        Connection oc = Out.getOutConnection();
        if (debugToGui && oc != null) {
            oc.recieveDebug("(" + source.getSimpleName() + ") " + text);
        } else if (outStream != null) {
            outStream.println("[" + TimeFormatter.getTimestamp() + "] (" + source.getSimpleName() + ") DEBUG " + text);
        }
    }

    public static void info(Class<?> source, String text) {
        Connection oc = Out.getOutConnection();
        if (oc != null) {
            oc.recieveInfo("(" + source.getSimpleName() + ") " + text);
        } else if (outStream != null) {
            outStream.println("[" + TimeFormatter.getTimestamp() + "] (" + source.getSimpleName() + ") INFO " + text);
        }
    }

    public static void setOutputStream(PrintStream s) {
        outStream = s;
    }

    public static void setThreadOutputConnection(Connection g) {
        outConnection.set(g);
    }

    public static void setThreadOutputConnectionIfNone(Connection g) {
        if (outConnection.get() == null) {
            outConnection.set(g);
        }
    }

    public static void setDefaultOutputConnection(Connection g) {
        outConnectionDefault = g;
    }

    public static void setDebug(boolean debug) {
        if (globalDebug == debug) {
            return;
        }
        globalDebug = debug;
        try {
            if (GlobalSettings.enableGUI) {
                GuiDesktop.updateDebugMenuText();
            }
            Out.debug(Out.class, "Debug logging " + (debug ? "en" : "dis") + "abled");
            Settings.write(null, "debug", debug);
            Settings.store();
        }
        catch (Throwable throwable) {}
    }

    public static void setDebug(String clazz, boolean debug) {
        boolean current;
        if (Out.debug.containsKey(clazz) && (current = Boolean.parseBoolean(Out.debug.getProperty(clazz))) == debug) {
            return;
        }
        Out.debug.setProperty(clazz, Boolean.toString(debug));
        Out.debug(Out.class, "Debug logging {" + clazz + "} " + (debug ? "en" : "dis") + "abled");
        try {
            Out.debug.store(new FileOutputStream(debugFile), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isDebug() {
        return globalDebug;
    }

    public static void setDebugToGui(boolean debug) {
        if (debugToGui == debug) {
            return;
        }
        debugToGui = debug;
        Settings.write(null, "debugToGui", debugToGui);
        Settings.store();
    }

    public static boolean isDebugToGui() {
        return debugToGui;
    }

    public static boolean isDebug(Class<?> clazz) {
        return Out.isDebug(clazz.getName());
    }

    public static boolean isDebug(String clazz) {
        if (!globalDebug) {
            return false;
        }
        if (debug.containsKey(clazz)) {
            return Boolean.parseBoolean(debug.getProperty(clazz));
        }
        Out.setDebug(clazz, true);
        return true;
    }

    public static Properties getProperties() {
        return debug;
    }
}

