/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.bnubot.util.Out;
import net.bnubot.util.SortedProperties;
import net.bnubot.vercheck.CurrentVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private static final File propsFile = new File("settings.ini");
    private static final Properties props = new SortedProperties();
    private static Boolean anythingChanged = false;

    static {
        if (propsFile.exists()) {
            try {
                props.load(new FileInputStream(propsFile));
            }
            catch (Exception e) {
                Out.exception(e);
            }
        }
    }

    private static String getKey(String header, String setting) {
        if (header == null) {
            return "general_" + setting;
        }
        return String.valueOf(header) + "_" + setting;
    }

    public static String read(String header, String setting, String defaultValue) {
        return props.getProperty(Settings.getKey(header, setting), defaultValue);
    }

    public static boolean read(String header, String setting, boolean defaultValue) {
        return Boolean.parseBoolean(Settings.read(header, setting, Boolean.toString(defaultValue)));
    }

    public static int read(String header, String setting, int defaultValue) {
        return Integer.parseInt(Settings.read(header, setting, Integer.toString(defaultValue)));
    }

    public static long read(String header, String setting, long defaultValue) {
        return Long.parseLong(Settings.read(header, setting, Long.toString(defaultValue)));
    }

    public static <T extends Enum<T>> T read(String header, String setting, T defaultValue) {
        return Enum.valueOf(defaultValue.getDeclaringClass(), Settings.read(header, setting, defaultValue.name()));
    }

    public static void write(String header, String setting, String value) {
        String key = Settings.getKey(header, setting);
        if (value == null) {
            value = new String();
        }
        if (props.containsKey(key) && props.getProperty(key).equals(value)) {
            return;
        }
        anythingChanged = true;
        Out.debug(Settings.class, "setting " + key + "=" + value);
        props.setProperty(key, value);
    }

    public static void write(String header, String setting, boolean value) {
        Settings.write(header, setting, Boolean.toString(value));
    }

    public static void write(String header, String setting, int value) {
        Settings.write(header, setting, Integer.toString(value));
    }

    public static void write(String header, String setting, long value) {
        Settings.write(header, setting, Long.toString(value));
    }

    public static <T extends Enum<T>> void write(String header, String setting, T value) {
        Settings.write(header, setting, value.name());
    }

    public static void store() {
        if (!anythingChanged.booleanValue()) {
            return;
        }
        Out.debug(Settings.class, "Writing settings.ini");
        try {
            String comment = CurrentVersion.version().toString();
            props.store(new FileOutputStream(propsFile), comment);
            anythingChanged = false;
        }
        catch (Exception e) {
            Out.fatalException(e);
        }
    }
}

